#include "cuda_runtime.h"
#include "device_launch_parameters.h"

#include <stdio.h>
#include <math.h>
#include <chrono>


// dev_a : SRF (AudioBlock x NofFrequencybins x Legendre )
// dev_c : AudioBlock x NofFrequencybins x Legendre x Legendre
cudaError_t Device_CovarianceSRF(float* dev_c, float* dev_a, float* dev_a_im, unsigned int freqanalysiswindow, unsigned int BlockSize, unsigned int tfheight, unsigned int freqstart, unsigned int legendresamples);
// OUT : dev_a : AudioBlock x NofFrequencybins x Nofsource x Legendre
// IN : dev_c : AudioBlock x NofFrequencybins x Legendre x Legendre
// IN : dev_wpfcoeff : Nofsource x Legendre
cudaError_t Device_LeftMultiplier(float* dev_c, float* dev_a, float* dev_wpfcoeff, unsigned int freqanalysiswindow, unsigned int BlockSize, unsigned int tfheight, unsigned int freqstart, unsigned int legendresamples, unsigned int nofsources);
// OUT : dev_a : AudioBlock x NofFrequencybins x Nofsource x Nofsource
// IN : dev_c : AudioBlock x NofFrequencybins x Nofsource x Legendre
// IN : dev_wpfcoeff : Nofsource x Legendre
cudaError_t Device_RightMultiplier(float* dev_c, float* dev_a, float* dev_wpfcoeff, unsigned int freqanalysiswindow, unsigned int BlockSize, unsigned int tfheight, unsigned int freqstart, unsigned int legendresamples, unsigned int nofsources);
// IN : dev_tfmultiplier : Nofsource x Nofsource
// IN : dev_a : AudioBlock x NofFrequencybins x Nofsources
// OUT : dev_a : AudioBlock x NofFrequencybins x Nofsources
cudaError_t Device_TFBinMasking(float* dev_a, float* dev_a_im, float* dev_mask_real, float* dev_tfmultiplier, float* dev_sumtfmultiplier, unsigned int freqanalysiswindow, unsigned int BlockSize, unsigned int tfheight, unsigned int freqstart, unsigned int legendresamples, unsigned int nofsources);
// IN : dev_tfmultiplier : AudioBlock x NofFrequencybins x Nofsource x Nofsource
// IN : dev_tfmultiplier_im : AudioBlock x NofFrequencybins x Nofsource x Nofsource
// OUT : dev_a : AudioBlock x NofFrequencybins 
cudaError_t Device_TFBinSummation(float* dev_sum, float* dev_tfmultiplier, unsigned int freqanalysiswindow, unsigned int BlockSize, unsigned int tfheight, unsigned int freqstart, unsigned int legendresamples, unsigned int nofsources);
