#include "healpixkernel.h"

healpixkernel::healpixkernel(int order)
{
	fstream fileStream;
	this->healpixorder = order;
	string str = to_string(order);
	fileStream.open(str+"_healpix_res.txt");

    if (fileStream.is_open())
    {
        std::string line;
        while (std::getline(fileStream, line))
        {
            std::stringstream ss(line);

            std::vector<std::string> enrolled;
            std::string course;
            while (std::getline(ss, course, ','))
            {
                enrolled.push_back(course); 
            }

            int neighbours[8] = {atoi(enrolled.at(3).c_str()), atoi(enrolled.at(4).c_str()), atoi(enrolled.at(5).c_str()), atoi(enrolled.at(6).c_str()), atoi(enrolled.at(7).c_str()), atoi(enrolled.at(8).c_str()), atoi(enrolled.at(9).c_str()), atoi(enrolled.at(10).c_str()) };
            pixels_invector.push_back(new pixelinfo(atoi(enrolled.at(0).c_str()), atof(enrolled.at(2).c_str()), atof(enrolled.at(1).c_str()), neighbours));
        }
    }
    else
    {
        cout << "Error opening file";
    }

}

void healpixkernel::ConvertSphericalToCartesian(float& distance, float& theta, float& phi,float& x, float& y, float& z)
{

    x = distance * sin(theta) * cos(phi);
    y = distance * sin(theta) * sin(phi);
    z = distance * cos(theta);

}

void healpixkernel::ConvertCartesionToSpherical(float& distance, float& theta, float& phi, float& x, float& y, float& z)
{

    theta = atan(y / x);
    phi = atan(sqrt(x*x +y*y)/z);

}

float healpixkernel::FindAngleBtw(float& x1, float& y1, float& z1, float& mag1, float& x2, float& y2, float& z2, float& mag2)
{
    float dotprod = (x1 * x2 + y1 * y2 + z1 * z2) / (mag1 * mag2);

    return acos(dotprod);
}

float healpixkernel::def_vonmises(float kappa,float costheta)
{
    float I0 = cyl_bessel_j(0, kappa);
    float gain = (-1) * exp(kappa * costheta) / (2 * PI * I0);
    return gain;
}

void healpixkernel::gethealpixcoordinates(int id, float& theta, float& phi)
{
    
    theta = pixels_invector.at(id)->elevation_in_radian;
    phi = pixels_invector.at(id)->azimuth_in_radian;
}

void healpixkernel::gethealpixindice(int& id, float theta, float phi)
{
    for (int kl = 0; kl < this->gethealpixnumberofpixels(); kl++)
    {
        id = kl;
        if (pixels_invector.at(id)->elevation_in_radian == theta && pixels_invector.at(id)->azimuth_in_radian == phi)
            break;
    }
}
int* healpixkernel::gethealpixneighbours(int id)
{
    return pixels_invector.at(id)->neighbour;
}

int healpixkernel::gethealpixorder()
{
    return this->healpixorder;
}

int healpixkernel::gethealpixnumberofpixels()
{
    return size(this->pixels_invector);
}

float* healpixkernel::calculatelegendrekernels(int max_sphorder)
{
    int samplenumber;
    if (this->healpixorder == 0)
        samplenumber = Order0_HP;
    else if (this->healpixorder == 1)
        samplenumber = Order1_HP;
    else if (this->healpixorder == 2)
        samplenumber = Order2_HP;
    else if (this->healpixorder == 3)
        samplenumber = Order3_HP;

    int arraysize = samplenumber * samplenumber;
    legendrekernels = (double*)calloc(arraysize , sizeof(double));
    legendrekernels_infloat = (float*)calloc(arraysize, sizeof(float));
    float th = 0;
    float ph = 0;
    float costheta = 0;


        for (int kl = 0; kl < samplenumber; kl++)
        {
            this->gethealpixcoordinates(kl, th, ph);
            // Center pixel directions in azimuth and elevation
            model::point<long double, 2, cs::spherical<radian> > p1((th), (ph));
            float maximum = 0.0;
            for (int klm = 0; klm < samplenumber; klm++)
            {
                    // Sampling pixel directions in azimuth and elevation
                    this->gethealpixcoordinates(klm, th, ph);
                    model::point<long double, 2, cs::spherical<radian> > p2((th), (ph));
                    costheta = cos(get<0>(p1)) * cos(get<0>(p2)) + cos(get<1>(p1) - get<1>(p2)) * sin(get<0>(p1)) * sin(get<0>(p2));

                    //legendrekernels[kl * samplenumber + klm] = (((2 * (double)(max_sphorder)) + 1) / (4 * PI)) * ((legendre_p(max_sphorder+1, costheta)- legendre_p(max_sphorder + 1, costheta)/ (legendre_p(1, costheta) - legendre_p(0, costheta))));

                    for (int jl = 0; jl <= max_sphorder; jl++)
                    {
                        legendrekernels[kl * samplenumber + klm] += (((2 * (double)(jl)) + 1) / (4 * PI)) * legendre_p(jl, costheta);
                    }

                    //if (legendrekernels[kl * samplenumber + klm] > maximum)
                        maximum += legendrekernels[kl * samplenumber + klm];

            }

            for (int klm = 0; klm < samplenumber; klm++)
            {
                legendrekernels_infloat[kl * samplenumber + klm] = (float)(legendrekernels[kl * samplenumber + klm] / maximum);
                legendrekernels[kl * samplenumber + klm] = (double)(legendrekernels[kl * samplenumber + klm] / maximum);
            }

        }


    return legendrekernels_infloat;
}


float* healpixkernel::calculatepw_magnitude(int Micnumber, float* micanglestheta, float* micanglesphi)
{
    int samplenumber;
    int max_sphorder = 4;

    if (this->healpixorder == 0)
        samplenumber = Order0_HP;
    else if (this->healpixorder == 1)
        samplenumber = Order1_HP;
    else if (this->healpixorder == 2)
        samplenumber = Order2_HP;
    else if (this->healpixorder == 3)
        samplenumber = Order3_HP;

    int arraysize = samplenumber * Micnumber;
    legendrekernels = (double*)calloc(arraysize, sizeof(double));
    legendrekernels_infloat = (float*)calloc(arraysize, sizeof(float));

    float th = 0;
    float ph = 0;
    float costheta = 0;


    for (int kl = 0; kl < samplenumber; kl++)
    {
        this->gethealpixcoordinates(kl, th, ph);
        // Center pixel directions in azimuth and elevation
        model::point<long double, 2, cs::spherical<radian> > p1((th), (ph));
        float maximum = 0.0;
        for (int klm = 0; klm < Micnumber; klm++)
        {
            // Sampling pixel directions in azimuth and elevation
            model::point<long double, 2, cs::spherical<radian> > p2((micanglestheta[klm]), (micanglesphi[klm]));

            costheta = cos(get<0>(p1)) * cos(get<0>(p2)) + cos(get<1>(p1) - get<1>(p2)) * sin(get<0>(p1)) * sin(get<0>(p2));
            for (int jl = 0; jl <= max_sphorder; jl++)
            {
                legendrekernels[kl * Micnumber + klm] += (((2 * (double)(jl)) + 1) / (4 * PI)) * legendre_p(jl, costheta);
            }

            if (legendrekernels[kl * Micnumber + klm] > maximum)
                maximum = legendrekernels[kl * Micnumber + klm];

        }

        for (int klm = 0; klm < Micnumber; klm++)
        {
            legendrekernels_infloat[kl * Micnumber + klm] = (float)(legendrekernels[kl * Micnumber + klm] / maximum);
            legendrekernels[kl * Micnumber + klm] = (double)(legendrekernels[kl * Micnumber + klm] / maximum);
        }

    }


    return legendrekernels_infloat;
}

float* healpixkernel::getpinvlegendrekernels(int hpnumber)
{
    float* piv_legendre = res_legendrekernels.at(hpnumber).memptr();

    return piv_legendre;

}

float* healpixkernel::getpinvkernels(int hpnumber)
{
    float* piv_legendre = pinv_legendrekernels.at(hpnumber).memptr();

    return piv_legendre;

}

void* healpixkernel::getmultiplicationresult()
{
    const int samplenumber = this->gethealpixnumberofpixels();

    multiplicationresult = (float*)malloc(sizeof(float) * samplenumber * samplenumber);

   double* locA =  (double*)legendrekernels;
   mat A(locA, samplenumber, samplenumber);

    double* locB = (double*)this->create_vonmisesfull();
    mat B(locB, samplenumber, samplenumber);

    mat C = B * A;

    memcpy((float*)multiplicationresult, conv_to<fmat>::from(C).memptr(), sizeof(float) * samplenumber * samplenumber);

    return multiplicationresult;

}

void* healpixkernel::calc_pinv_matrices(int nofsources,vector<float> Az, vector<float> El)
{
    const int samplenumber = this->gethealpixnumberofpixels();

    int indice;
    float theta, phi;
    pinv_multiplier_indouble = (double*)malloc(nofsources * samplenumber * sizeof(double));
    pinv_multiplier = (float*)malloc(nofsources * samplenumber * sizeof(float));
    for (int klm = 0; klm < nofsources; klm++)
    {
        gethealpixindice(indice, Az.at(klm), El.at(klm));
        memcpy((double*)(pinv_multiplier_indouble + (klm * samplenumber)), (double*)(legendrekernels + (indice * samplenumber)), sizeof(double) * samplenumber);
    }

    mat A(pinv_multiplier_indouble, samplenumber, nofsources);
    mat B = pinv(A);
    
    memcpy((float*)pinv_multiplier, conv_to<fmat>::from(B).memptr(), sizeof(float) * nofsources * samplenumber);

    return pinv_multiplier;

}

void* healpixkernel::calculateorthogonalLK()
{
    const int samplenumber = this->gethealpixnumberofpixels();

    mat D = eye<mat>(samplenumber, samplenumber);

    mat Res;

    for (int kl = 0; kl < samplenumber; kl++)
    {
        //Psi for the selected legendre kernel 1x192
        //legendrekernel.SetData();
        double* loc = (double*)&legendrekernels[kl * samplenumber];
        mat A(loc, 1, samplenumber);
        mat B = pinv(A.t());

        

        pinv_legendrekernels.push_back(conv_to<fmat>::from(B));
        mat C = A.t() * B;
        Res = D - C;
        res_legendrekernels.push_back(conv_to<fmat>::from(Res));
    }



    return 0;
}

void* healpixkernel::calculateSRFMultiplier(int max_sphorder,int nofmicrophones, int freqrange,vector<float> micanglestheta, vector<float> micanglesphi, float* realpart, float* imagpart)
{
    int samplenumber = this->gethealpixnumberofpixels();

    float th = 0;
    float ph = 0;
    float costheta = 0;
    complex<float> comple(0, 1);

            int cnt = 0;
            int kr;
            // Output is Healpix number of Pixels * Microphone numbers

            for (int kr = 1; kr < (max_sphorder +1); kr++)
            {
                for (int kl = 0; kl < samplenumber; kl++)
                {
                    this->gethealpixcoordinates(kl, th, ph);

                    for (int il = 0; il < nofmicrophones; il++)
                    {

                        // Center pixel directions in azimuth and elevation
                        model::point<long double, 2, cs::spherical<radian> > p1((th), (ph));

                        model::point<long double, 2, cs::spherical<radian> > p2((micanglestheta[il]), (micanglesphi[il]));
                        complex<float> calcharmonic(0, 0);
                        for (int sph_n = 0; sph_n <= max_sphorder; sph_n++)
                        {
                            // if kr=1 N =1
                            // if kr=2 N =2
                            // if kr=3 N =3
                            // if kr=4 N =4

                            complex<float> bessel_s = (complex<float>)boost::math::sph_bessel(sph_n, kr);

                            complex<float> bessel_p = (complex<float>)boost::math::sph_bessel_prime(sph_n, kr);


                            complex<float> h2 = (complex<float>)boost::math::sph_hankel_2(sph_n, kr);
                            complex<float> h2_prime = (complex<float>)0.5 * ((complex<float>)boost::math::sph_hankel_2(sph_n - 1, kr) - (complex<float>)boost::math::sph_hankel_2(sph_n + 1, kr));

                                // printf("%d, %f, %f, (%f,%f), (%f,%f)\n", sph_n, bessel_s.real(), bessel_p.real(), h2.real(), h2.imag(), h2_prime.real(), h2_prime.imag());

                            complex<float> bessel = bessel_s - ((bessel_p / h2_prime) * h2);
                            
                            complex<float> interm = (complex<float>)(4 * PI) * (complex<float>)pow(comple, sph_n);
                            complex<float> midterm = interm * bessel;

                            complex<float> mic_conj;
                            complex<float> healp;

                            for (int sph_m = ((-1) * sph_n); sph_m <= sph_n; sph_m++)
                            {
                                mic_conj = conj((complex<float>)boost::math::spherical_harmonic(sph_n, sph_m, get<0>(p2), get<1>(p2)));
                                healp = (complex<float>)boost::math::spherical_harmonic(sph_n, sph_m, get<0>(p1), get<1>(p1));
                                calcharmonic += (healp * mic_conj / midterm);
                            }
                        }

                        realpart[(kr-1) * samplenumber * nofmicrophones + kl * nofmicrophones + il] = calcharmonic.real();
                        imagpart[(kr-1) * samplenumber * nofmicrophones + kl * nofmicrophones + il] = calcharmonic.imag();
                    }

                }

            }
    return 0;
}

double* healpixkernel::create_vonmises(int hpnumber_center)
{


    int samplenumber = this->gethealpixnumberofpixels();
    int arraysize = samplenumber;

    float dist_cnt= 1.0, dist = 1.0;
    float th_cnt,th = 0;
    float ph_cnt,ph = 0;
    float x_cnt, x = 0;
    float y_cnt, y = 0;
    float z_cnt, z = 0;
    float costheta = 0;
    float dotprod;

    vonmises_values = (double*)calloc(samplenumber, sizeof(double));

    this->gethealpixcoordinates(hpnumber_center, th_cnt, ph_cnt);
    ConvertSphericalToCartesian(dist_cnt,th_cnt, ph_cnt, x_cnt, y_cnt, z_cnt);

    double max = 0.0;

    for (int kl = 0; kl < samplenumber; kl++)
    {
        this->gethealpixcoordinates(kl, th, ph);
        ConvertSphericalToCartesian(dist, th, ph, x, y, z);

        dotprod = (x_cnt * x + y_cnt * y + z_cnt * z);
        vonmises_values[kl] = def_vonmises(Kappa, dotprod);

        if (vonmises_values[kl] > max)
            max = vonmises_values[kl];
    }

    for (int kl = 0; kl < samplenumber; kl++)
    {
        vonmises_values[kl] = (double)((vonmises_values[kl] / HPMaxvalue) / max);
    }

    return vonmises_values;

}

double* healpixkernel::create_vonmisesfull()
{


    int samplenumber = this->gethealpixnumberofpixels();
    int arraysize = samplenumber;

    float dist_cnt = 1.0, dist = 1.0;
    float th_cnt, th = 0;
    float ph_cnt, ph = 0;
    float x_cnt, x = 0;
    float y_cnt, y = 0;
    float z_cnt, z = 0;
    float costheta = 0;
    float dotprod;

    vonmises_values = (double*)calloc(samplenumber* samplenumber, sizeof(double));

    for (int jkl = 0; jkl < samplenumber; jkl++)
    {

        this->gethealpixcoordinates(jkl, th_cnt, ph_cnt);
        ConvertSphericalToCartesian(dist_cnt, th_cnt, ph_cnt, x_cnt, y_cnt, z_cnt);

        double max = 0.0;

        for (int kl = 0; kl < samplenumber; kl++)
        {
            this->gethealpixcoordinates(kl, th, ph);
            ConvertSphericalToCartesian(dist, th, ph, x, y, z);

            dotprod = (x_cnt * x + y_cnt * y + z_cnt * z);
            vonmises_values[kl * samplenumber + jkl] = def_vonmises(Kappa, dotprod);

            if (vonmises_values[kl * samplenumber + jkl] > max)
                max = vonmises_values[kl * samplenumber + jkl];
        }

        for (int kl = 0; kl < samplenumber; kl++)
        {
            vonmises_values[kl * samplenumber + jkl] = (double)(vonmises_values[kl * samplenumber + jkl] / HPMaxvalue) / max;
        }
    }

    return vonmises_values;

}
