from PIL import Image,ImageDraw,ImageFont
import math as m 

def toCartesian(r,theta,phi):
     x = r * m.cos(phi) * m.sin(theta)
     y = r * m.sin(phi) * m.sin(theta)
     z = r * m.cos(theta)
     #print(x,y,z)
     return x,y,z

txt = Image.new("RGBA",(203,203),(255,255,255,0))
fnt = ImageFont.load_default()
d = ImageDraw.Draw(txt)


y_start = 0
y_end = txt.height
step_size = int(txt.width / 10)

for x in range(0, txt.width,step_size):
     line = ((x,y_start),(x,y_end))
     d.line(line,fill=(0,0,0,255))

x_start = 0
x_end = txt.width

for y in range(0,txt.height,step_size):
      line = ((x_start,y),(x_end,y))
      d.line(line,fill=(0,0,0,255))      

txt_wrt = ["x","o","+","u","/","-",":"]
d.text((int(txt.width /2),int(txt.height / 2)),"C", font=fnt, fill=(255,0,0,255))
blocks = []
with open("recordings.txt","r") as infile:
        for line in infile:
            sources = []
            variables = line.split(";")
            sid = int(variables[0])
            for si in range(0,sid):
                  sources.append([variables[si*2+1],variables[si*2+2]])
                  x,y,z = toCartesian(100.0, float(variables[si+1]),float(variables[si+2]))
                  d.text((int(100.0 + x),int(100.0 + (-1) * y)),txt_wrt[si], font=fnt, fill=(0,0,0,128))
            #if sid>0:
            blocks.append(sources)

for id in range(0,len(blocks)):
      print(blocks[id])
      


#out = Image.alpha_composite(base,txt)
txt.save("trajectory.png")
      