
#include "cuda_runtime.h"
#include "device_launch_parameters.h"

#include <stdio.h>
#include <math.h>
#include <chrono>

// STFT input to SRF
cudaError_t Device_DComplexmultiplyWithCuda(float* dev_c, float* dev_c_im, float* dev_a, float* dev_b, float* dev_a_im, float* dev_b_im, unsigned int micsize, unsigned int tfheight, unsigned int size, unsigned int BlockSize, unsigned int freqstart, unsigned int legendresamples, float* dev_kr_matrix);
// SRF multiplication with kernels
cudaError_t Device_DmultiplyWithCuda(float* dev_c, float* dev_c_im, float* dev_a, float* dev_b, float* dev_a_im, unsigned int freqanalysiswindow, unsigned int BlockSize, unsigned int tfheight, unsigned int freqstart, unsigned int legendresamples,float* dev_kr_matrix);
// Histogram calculation kernel
cudaError_t Device_GetHistogram(float* dev_next, float* dev_next_im, float* dev_a, unsigned int freqanalysis, unsigned int legendresamples, unsigned int BlockSize);
//Direct residual kernel calculator
cudaError_t RescomplexmatrixMultiplicationKernel(float* c, float* c_im, float* a, float* b, float* a_im, float* hist, unsigned int freqnumber, unsigned int legendresamples, unsigned int BlockSize, float* dev_kr_matrix);
//Direct multiplication kernel
cudaError_t MagcomplexmatrixMultiplicationKernel(float* c, float* c_im, float* a, float* b, float* a_im, float* hist, unsigned int noffrequency, unsigned int legendresamples, unsigned int BlockSize, float* dev_kr_matrix);
//Swap matrices kernel
cudaError_t Swapmatrices(float* c, float* c_im, float* a, float* a_im, unsigned int noffrequency, unsigned int BlockSize, unsigned int legendresamples);
cudaError_t Swapmatrices2D(float* c, float* c_im, float* a, float* a_im, unsigned int size, unsigned int BlockSize);
// According to the magnitudes of the signal calculate RENT histogram
cudaError_t RENTHistogramKernel(float* c, float* c_im, float* a, float* a_im, float* hist, float* RENThist, unsigned int legendresamples, unsigned int BlockSize, unsigned int noffreqbins);
// Separated sources are obtained
cudaError_t OMPSeparatedSources(float* dev_result, float* dev_result_im, float* dev_prev_result, float* dev_prev_result_im, float* dev_multiplication_kernel, float* dev_multiplication_kernel_imag, float* dev_magnitudes, float* dev_magnitudes_im, float* dev_general_histogram, unsigned int BlockSize, unsigned int legendresamples, unsigned int NofFrequencyBins, unsigned int WindowLength, unsigned int nofiterations, float* sourcedoa, unsigned int nofsources, unsigned int prev_nofsources,float* dev_pressurelevel,float* dev_krmatrix);
