#include "healpixkernel_sds.h"

healpixkernel_sds::healpixkernel_sds(int order)
{
	fstream fileStream;
	this->healpixorder = order;
	string str = to_string(order);
	fileStream.open(str+"_healpix_res.txt");

    if (fileStream.is_open())
    {
        std::string line;
        while (std::getline(fileStream, line))
        {
            std::stringstream ss(line);

            std::vector<std::string> enrolled;
            std::string course;
            while (std::getline(ss, course, ','))
            {
                enrolled.push_back(course); 
            }

            int neighbours[8] = {atoi(enrolled.at(3).c_str()), atoi(enrolled.at(4).c_str()), atoi(enrolled.at(5).c_str()), atoi(enrolled.at(6).c_str()), atoi(enrolled.at(7).c_str()), atoi(enrolled.at(8).c_str()), atoi(enrolled.at(9).c_str()), atoi(enrolled.at(10).c_str()) };
            pixels_invector.push_back(new pixelinfo_sds(atoi(enrolled.at(0).c_str()), atof(enrolled.at(2).c_str()), atof(enrolled.at(1).c_str()), neighbours));
        }
    }
    else
    {
        cout << "Error opening file";
    }

    kr1 = (complex<float>*)malloc(sizeof(complex<float>) * 2);
    kr2 = (complex<float>*)malloc(sizeof(complex<float>) * 3);
    kr3 = (complex<float>*)malloc(sizeof(complex<float>) * 4);
    kr4 = (complex<float>*)malloc(sizeof(complex<float>) * 5);

}

void healpixkernel_sds::ConvertSphericalToCartesian(float& distance, float& theta, float& phi,float& x, float& y, float& z)
{

    x = distance * sin(theta) * cos(phi);
    y = distance * sin(theta) * sin(phi);
    z = distance * cos(theta);

}

void healpixkernel_sds::ConvertCartesionToSpherical(float& distance, float& theta, float& phi, float& x, float& y, float& z)
{

    theta = atan2(y , x);
    phi = atan2(sqrt(x*x +y*y),z);

}

float healpixkernel_sds::FindAngleBtw(float& x1, float& y1, float& z1, float& mag1, float& x2, float& y2, float& z2, float& mag2)
{
    float dotprod = (x1 * x2 + y1 * y2 + z1 * z2) / (mag1 * mag2);

    return acos(dotprod);
}

float healpixkernel_sds::def_vonmises(float kappa,float costheta)
{
    float I0 = abs(boost::math::sph_bessel(0, kappa));
    float gain = exp(kappa * costheta) / (2 * PI * I0);
    return gain;
}

void healpixkernel_sds::gethealpixcoordinates(int id, float& theta, float& phi)
{
    
    theta = pixels_invector.at(id)->elevation_in_radian;
    phi = pixels_invector.at(id)->azimuth_in_radian;
}

void healpixkernel_sds::gethealpixindice(int& id, float theta, float phi)
{
    for (int kl = 0; kl < this->gethealpixnumberofpixels(); kl++)
    {
        id = kl;
        if (pixels_invector.at(id)->elevation_in_radian == theta && pixels_invector.at(id)->azimuth_in_radian == phi)
            break;
    }
}
int* healpixkernel_sds::gethealpixneighbours(int id)
{
    return pixels_invector.at(id)->neighbour;
}

int healpixkernel_sds::gethealpixorder()
{
    return this->healpixorder;
}

int healpixkernel_sds::gethealpixnumberofpixels()
{
    return size(this->pixels_invector);
}

void healpixkernel_sds::setmicarray_parameters(int kr_id, string values)
{ 
    int counter; 
    float p_val_real, p_val_imag;
    if (kr_id == 0)
    {
        counter = 2;
        p_val_real = stof(strtok((char*)(values.data()), ","));
        for (int klm = 0; klm < counter; klm++)
        {
            
            p_val_imag = stof(strtok((char*)(NULL), ","));
            *(kr1+klm) = complex<float>(p_val_real, p_val_imag);
            if(klm != (counter-1))
                p_val_real = stof(strtok((char*)(NULL), ","));
        }
    }
    else if (kr_id == 1)
    {
        counter = 3;
        p_val_real = stof(strtok((char*)(values.data()), ","));
        for (int klm = 0; klm < counter; klm++)
        {

            p_val_imag = stof(strtok((char*)(NULL), ","));
            *(kr2 + klm) = complex<float>(p_val_real, p_val_imag);
            if (klm != (counter - 1))
                p_val_real = stof(strtok((char*)(NULL), ","));
        }

    }
    else if (kr_id == 2)
    {
        counter = 4;
        p_val_real = stof(strtok((char*)(values.data()), ","));
        for (int klm = 0; klm < counter; klm++)
        {

            p_val_imag = stof(strtok((char*)(NULL), ","));
            *(kr3 + klm) = complex<float>(p_val_real, p_val_imag);
            if (klm != (counter - 1))
                p_val_real = stof(strtok((char*)(NULL), ","));
        }

    }
    else if (kr_id == 3)
    {
        counter = 5;
        p_val_real = stof(strtok((char*)(values.data()), ","));
        for (int klm = 0; klm < counter; klm++)
        {

            p_val_imag = stof(strtok((char*)(NULL), ","));
            *(kr4 + klm) = complex<float>(p_val_real, p_val_imag);
            if (klm != (counter - 1))
                p_val_real = stof(strtok((char*)(NULL), ","));
        }

    }

}

float* healpixkernel_sds::calculatelegendrekernels_bnkra(int max_sphorder)
{
    int samplenumber;
    if (this->healpixorder == 0)
        samplenumber = Order0_HP;
    else if (this->healpixorder == 1)
        samplenumber = Order1_HP;
    else if (this->healpixorder == 2)
        samplenumber = Order2_HP;
    else if (this->healpixorder == 3)
        samplenumber = Order3_HP;

    int arraysize = samplenumber * samplenumber;
    legendrekernels_bnkra = (double*)calloc(arraysize, sizeof(double));
    legendrekernels_infloat_bnkra = (float*)calloc(arraysize, sizeof(float));

    legendrekernels_bnkra_imag = (double*)calloc(arraysize, sizeof(double));
    legendrekernels_infloat_bnkra_imag = (float*)calloc(arraysize, sizeof(float));
    float th = 0;
    float ph = 0;
    float costheta = 0;
    complex<float> comple(0, 1);
    int kr = max_sphorder;

        for (int kl = 0; kl < samplenumber; kl++)
        {
            this->gethealpixcoordinates(kl, th, ph);
            // Center pixel directions in azimuth and elevation
            model::point<long double, 2, cs::spherical<radian> > p1((th), (ph));
            float maximum = 0.0;
            for (int klm = 0; klm < samplenumber; klm++)
            {
                // Sampling pixel directions in azimuth and elevation
                this->gethealpixcoordinates(klm, th, ph);
                model::point<long double, 2, cs::spherical<radian> > p2((th), (ph));
                costheta = cos(get<0>(p1)) * cos(get<0>(p2)) + cos(get<1>(p1) - get<1>(p2)) * sin(get<0>(p1)) * sin(get<0>(p2));
                complex<float> out(0, 0);
                complex<float> midterm;
                for (int jl = 0; jl <= max_sphorder; jl++)
                {

                    if(kr==1)
                        midterm  = kr1[jl];
                    else if(kr==2)
                        midterm = kr2[jl];
                    else if (kr == 3)
                        midterm = kr3[jl];
                    else if (kr == 4)
                        midterm = kr4[jl];

                   out += midterm * complex<float>((2 * (double)(jl)) + 1) * complex<float>(legendre_p(jl, costheta));

                }
                legendrekernels_bnkra[kl * samplenumber + klm] = out.real();
                legendrekernels_bnkra_imag[kl * samplenumber + klm] = out.imag();

            }

            for (int klm = 0; klm < samplenumber; klm++)
            {
                legendrekernels_infloat_bnkra[kl * samplenumber + klm] = (float)(legendrekernels_bnkra[kl * samplenumber + klm]);// / maximum);
                legendrekernels_bnkra[kl * samplenumber + klm] = (double)(legendrekernels_bnkra[kl * samplenumber + klm]);// / maximum);

                legendrekernels_infloat_bnkra_imag[kl * samplenumber + klm] = (float)(legendrekernels_bnkra_imag[kl * samplenumber + klm]);// / maximum);
                legendrekernels_bnkra_imag[kl * samplenumber + klm] = (double)(legendrekernels_bnkra_imag[kl * samplenumber + klm]);// / maximum);
            }
        }


    return legendrekernels_infloat_bnkra;
}

float* healpixkernel_sds::calculatelegendrekernels(int max_sphorder)
{
    int samplenumber;
    if (this->healpixorder == 0)
        samplenumber = Order0_HP;
    else if (this->healpixorder == 1)
        samplenumber = Order1_HP;
    else if (this->healpixorder == 2)
        samplenumber = Order2_HP;
    else if (this->healpixorder == 3)
        samplenumber = Order3_HP;

    int arraysize = samplenumber * samplenumber;
    legendrekernels = (double*)calloc(arraysize , sizeof(double));
    legendrekernels_infloat = (float*)calloc(arraysize, sizeof(float));
    float th = 0;
    float ph = 0;
    float costheta = 0;


        for (int kl = 0; kl < samplenumber; kl++)
        {
            this->gethealpixcoordinates(kl, th, ph);
            // Center pixel directions in azimuth and elevation
            model::point<long double, 2, cs::spherical<radian> > p1((th), (ph));
            float maximum = 0.0;
            for (int klm = 0; klm < samplenumber; klm++)
            {
                    // Sampling pixel directions in azimuth and elevation
                    this->gethealpixcoordinates(klm, th, ph);
                    model::point<long double, 2, cs::spherical<radian> > p2((th), (ph));
                    costheta = cos(get<0>(p1)) * cos(get<0>(p2)) + cos(get<1>(p1) - get<1>(p2)) * sin(get<0>(p1)) * sin(get<0>(p2));

                    //legendrekernels[kl * samplenumber + klm] = (((2 * (double)(max_sphorder)) + 1) / (4 * PI)) * ((legendre_p(max_sphorder+1, costheta)- legendre_p(max_sphorder + 1, costheta)/ (legendre_p(1, costheta) - legendre_p(0, costheta))));

                    for (int jl = 0; jl <= max_sphorder; jl++)
                    {
                        legendrekernels[kl * samplenumber + klm] += (((2 * (double)(jl)) + 1)) * legendre_p(jl, costheta);
                    }

                    //if (legendrekernels[kl * samplenumber + klm] > maximum)
                       // maximum += legendrekernels[kl * samplenumber + klm];

            }

            for (int klm = 0; klm < samplenumber; klm++)
            {
                legendrekernels_infloat[kl * samplenumber + klm] = (float)(legendrekernels[kl * samplenumber + klm]);// / maximum);
                legendrekernels[kl * samplenumber + klm] = (double)(legendrekernels[kl * samplenumber + klm]);// / maximum);
            }

        }


    return legendrekernels_infloat;
}


float* healpixkernel_sds::calculatepw_magnitude(int Micnumber, float* micanglestheta, float* micanglesphi)
{
    int samplenumber;
    int max_sphorder = 4;

    if (this->healpixorder == 0)
        samplenumber = Order0_HP;
    else if (this->healpixorder == 1)
        samplenumber = Order1_HP;
    else if (this->healpixorder == 2)
        samplenumber = Order2_HP;
    else if (this->healpixorder == 3)
        samplenumber = Order3_HP;

    int arraysize = samplenumber * Micnumber;
    legendrekernels = (double*)calloc(arraysize, sizeof(double));
    legendrekernels_infloat = (float*)calloc(arraysize, sizeof(float));

    float th = 0;
    float ph = 0;
    float costheta = 0;


    for (int kl = 0; kl < samplenumber; kl++)
    {
        this->gethealpixcoordinates(kl, th, ph);
        // Center pixel directions in azimuth and elevation
        model::point<long double, 2, cs::spherical<radian> > p1((th), (ph));
        float maximum = 0.0;
        for (int klm = 0; klm < Micnumber; klm++)
        {
            // Sampling pixel directions in azimuth and elevation
            model::point<long double, 2, cs::spherical<radian> > p2((micanglestheta[klm]), (micanglesphi[klm]));

            costheta = cos(get<0>(p1)) * cos(get<0>(p2)) + cos(get<1>(p1) - get<1>(p2)) * sin(get<0>(p1)) * sin(get<0>(p2));
            for (int jl = 0; jl <= max_sphorder; jl++)
            {
                legendrekernels[kl * Micnumber + klm] += (((2 * (double)(jl)) + 1) ) * legendre_p(jl, costheta);
            }

            if (legendrekernels[kl * Micnumber + klm] > maximum)
                maximum = legendrekernels[kl * Micnumber + klm];

        }

        for (int klm = 0; klm < Micnumber; klm++)
        {
            legendrekernels_infloat[kl * Micnumber + klm] = (float)(legendrekernels[kl * Micnumber + klm] / maximum);
            legendrekernels[kl * Micnumber + klm] = (double)(legendrekernels[kl * Micnumber + klm] / maximum);
        }

    }


    return legendrekernels_infloat;
}

float* healpixkernel_sds::getpinvlegendrekernels(int hpnumber)
{
    float* piv_legendre = res_legendrekernels.at(hpnumber).memptr();

    return piv_legendre;

}

float* healpixkernel_sds::getpinvkernels(int hpnumber)
{
    float* piv_legendre = pinv_legendrekernels.at(hpnumber).memptr();

    return piv_legendre;

}

void* healpixkernel_sds::getmultiplicationresult(int max_sphorder)
{
    const int samplenumber = this->gethealpixnumberofpixels();

    multiplicationresult = (float*)malloc(sizeof(float) * max_sphorder * samplenumber * samplenumber);

    multiplicationresult_imag = (float*)malloc(sizeof(float) * max_sphorder * samplenumber * samplenumber);



    for (int klh = 1; klh <= max_sphorder; klh++)
    {
        int index = (klh - 1) * samplenumber * samplenumber;

        this->calculatelegendrekernels_bnkra(klh);

        double* locA = (double*)legendrekernels_bnkra;
        mat A(locA, samplenumber, samplenumber);

        double* locB = (double*)this->create_vonmisesfull();
        mat B(locB, samplenumber, samplenumber);

        mat C = B * A;

        double* locD = (double*)legendrekernels_bnkra_imag;
        mat D(locD, samplenumber, samplenumber);

        memcpy((float*)(multiplicationresult+ index), conv_to<fmat>::from(C).memptr(), sizeof(float) * samplenumber * samplenumber);

        mat E = B * D;

        memcpy((float*)(multiplicationresult_imag + index), conv_to<fmat>::from(E).memptr(), sizeof(float) * samplenumber * samplenumber);


    }

    return multiplicationresult;

}

void* healpixkernel_sds::calc_pinv_matrices(int nofsources,vector<float> Az, vector<float> El)
{
    const int samplenumber = this->gethealpixnumberofpixels();

    int indice;
    float theta, phi;
    pinv_multiplier_indouble = (double*)malloc(nofsources * samplenumber * sizeof(double));
    pinv_multiplier = (float*)malloc(nofsources * samplenumber * sizeof(float));
    for (int klm = 0; klm < nofsources; klm++)
    {
        gethealpixindice(indice, Az.at(klm), El.at(klm));
        memcpy((double*)(pinv_multiplier_indouble + (klm * samplenumber)), (double*)(legendrekernels + (indice * samplenumber)), sizeof(double) * samplenumber);
    }

    mat A(pinv_multiplier_indouble, samplenumber, nofsources);
    mat B = pinv(A);
    
    memcpy((float*)pinv_multiplier, conv_to<fmat>::from(B).memptr(), sizeof(float) * nofsources * samplenumber);

    return pinv_multiplier;

}

void* healpixkernel_sds::calculateorthogonalLK()
{
    const int samplenumber = this->gethealpixnumberofpixels();

    mat D = eye<mat>(samplenumber, samplenumber);

    mat Res;
   pinv_legendrekernels.clear();
   res_legendrekernels.clear();


    for (int kl = 0; kl < samplenumber; kl++)
    {
        //Psi for the selected legendre kernel 1x192
        //legendrekernel.SetData();
        double* loc = (double*)&legendrekernels[kl * samplenumber];
        mat A(loc, 1, samplenumber);
        mat B = pinv(A.t());

        

        pinv_legendrekernels.push_back(conv_to<fmat>::from(B));
        mat C = A.t() * B;
        Res = D - C;
        res_legendrekernels.push_back(conv_to<fmat>::from(Res));
    }



    return 0;
}

void* healpixkernel_sds::calculateSRFMultiplier(int max_sphorder,int nofmicrophones, int freqrange,vector<float> micanglestheta, vector<float> micanglesphi, float* realpart, float* imagpart)
{
    int samplenumber = this->gethealpixnumberofpixels();

    float th = 0;
    float ph = 0;
    float costheta = 0;
    complex<float> comple(0, 1);

            int cnt = 0;
            int kr;
            int sphorder_limit;
            // Output is Healpix number of Pixels * Microphone numbers

            for (int kr = 1; kr < (max_sphorder +1); kr++)
            {
                for (int kl = 0; kl < samplenumber; kl++)
                {
                    this->gethealpixcoordinates(kl, th, ph);

                    for (int il = 0; il < nofmicrophones; il++)
                    {

                        // Center pixel directions in azimuth and elevation
                        model::point<long double, 2, cs::spherical<radian> > p1((th), (ph));

                        model::point<long double, 2, cs::spherical<radian> > p2((micanglestheta[il]), (micanglesphi[il]));
                        complex<float> calcharmonic(0, 0);
                        if (kr == 1)
                            sphorder_limit = 1;
                        if (kr == 2)
                            sphorder_limit = 2;
                        if (kr == 3)
                            sphorder_limit = 3;
                        if (kr == 4)
                            sphorder_limit = 4;
                        complex<float> midterm;
                        for (int sph_n = 0; sph_n <= sphorder_limit; sph_n++)
                        {

                           if (kr == 1)
                                midterm = kr1[sph_n];
                            else if (kr == 2)
                                midterm = kr2[sph_n];
                            else if (kr == 3)
                                midterm = kr3[sph_n];
                            else if (kr == 4)
                                midterm = kr4[sph_n];
                                
                            complex<float> mic_conj;
                            complex<float> healp;

                            for (int sph_m = ((-1) * sph_n); sph_m <= sph_n; sph_m++)
                            {
                                mic_conj = conj((complex<float>)boost::math::spherical_harmonic(sph_n, sph_m, get<0>(p2), get<1>(p2)));
                                healp = (complex<float>)boost::math::spherical_harmonic(sph_n, sph_m, get<0>(p1), get<1>(p1));
                                calcharmonic += (healp * mic_conj / midterm);
                            }
                        }

                        realpart[(kr-1) * samplenumber * nofmicrophones + kl * nofmicrophones + il] = calcharmonic.real();
                        imagpart[(kr-1) * samplenumber * nofmicrophones + kl * nofmicrophones + il] = calcharmonic.imag();
                    }

                }

            }
    return 0;
}

double* healpixkernel_sds::create_vonmises(int hpnumber_center)
{


    int samplenumber = this->gethealpixnumberofpixels();
    int arraysize = samplenumber;

    float dist_cnt= 1.0, dist = 1.0;
    float th_cnt,th = 0;
    float ph_cnt,ph = 0;
    float x_cnt, x = 0;
    float y_cnt, y = 0;
    float z_cnt, z = 0;
    float costheta = 0;
    float dotprod;

    vonmises_values = (double*)calloc(samplenumber, sizeof(double));

    this->gethealpixcoordinates(hpnumber_center, th_cnt, ph_cnt);
    ConvertSphericalToCartesian(dist_cnt,th_cnt, ph_cnt, x_cnt, y_cnt, z_cnt);

    double max = 0.0;

    for (int kl = 0; kl < samplenumber; kl++)
    {
        this->gethealpixcoordinates(kl, th, ph);
        ConvertSphericalToCartesian(dist, th, ph, x, y, z);

        dotprod = (x_cnt * x + y_cnt * y + z_cnt * z);
        vonmises_values[kl] = def_vonmises(Kappa, dotprod);

        if (vonmises_values[kl] > max)
            max = vonmises_values[kl];
    }

    for (int kl = 0; kl < samplenumber; kl++)
    {
        vonmises_values[kl] = (double)((vonmises_values[kl]) / max);
    }

    return vonmises_values;

}

double* healpixkernel_sds::create_vonmisesfull()
{


    int samplenumber = this->gethealpixnumberofpixels();
    int arraysize = samplenumber;

    float dist_cnt = 1.0, dist = 1.0;
    float th_cnt, th = 0;
    float ph_cnt, ph = 0;
    float x_cnt, x = 0;
    float y_cnt, y = 0;
    float z_cnt, z = 0;
    float costheta = 0;
    float dotprod;

    vonmises_values = (double*)calloc(samplenumber* samplenumber, sizeof(double));

    for (int jkl = 0; jkl < samplenumber; jkl++)
    {

        this->gethealpixcoordinates(jkl, th_cnt, ph_cnt);
        ConvertSphericalToCartesian(dist_cnt, th_cnt, ph_cnt, x_cnt, y_cnt, z_cnt);

        double max = 0.0;

        for (int kl = 0; kl < samplenumber; kl++)
        {
            this->gethealpixcoordinates(kl, th, ph);
            ConvertSphericalToCartesian(dist, th, ph, x, y, z);

            dotprod = (x_cnt * x + y_cnt * y + z_cnt * z);
            vonmises_values[kl * samplenumber + jkl] = def_vonmises(Kappa, dotprod);

            if (vonmises_values[kl * samplenumber + jkl] > max)
                max = vonmises_values[kl * samplenumber + jkl];
        }

        for (int kl = 0; kl < samplenumber; kl++)
        {
            vonmises_values[kl * samplenumber + jkl] = (double)(vonmises_values[kl * samplenumber + jkl] ) / max;
        }
    }

    return vonmises_values;

}


void* healpixkernel_sds::return_multiplicationresult_real()
{

    return multiplicationresult;

}

void* healpixkernel_sds::return_multiplicationresult_imag()
{

    return multiplicationresult_imag;

}
