#pragma once

#include "micarray.h"

#ifndef Q_MOC_RUN
#include "boost/geometry.hpp"
#endif

#include "boost/math/special_functions/bessel.hpp"
#include "boost/math/special_functions/bessel_prime.hpp"
#include "boost/math/special_functions/legendre.hpp"
#include "boost/math/special_functions/hankel.hpp"
#include "boost/math/special_functions/spherical_harmonic.hpp"
#include "boost/variant/get.hpp"


#include <nlohmann/json.hpp>



#define SHDorder 1
#define PI 3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068

using namespace std;
using namespace boost::geometry;
using namespace boost::math;
using json = nlohmann::json;

enum class ArrayType
{
	Spherical,
	Circular,
	Planar,
	Linear,
	Other
};

enum class ArrayScattering
{
	Rigid,
	Open,
	OtherArray
};

class soundfielddescription
{
public:
    soundfielddescription();
    void* calcsphericalharmonics(double* pressure_real_in, double* pressure_imag_in, double* shd_realpart_out, double* shd_imagpart_out);
private:
	vector<float> micanglestheta;
	vector<float> micanglesphi;
    int nofmicrophones;
    int nofsamples;
    ArrayType array_type;
    ArrayScattering array_scattering_type;
	int sampling_rate;
	int sample_type;
	int block_size;
	int samplingrates[8] = { 16000,24000,32000,44100,48000,64000,96000,192000 };
	int sampletypes[3] = { 16,24,32 };
	int blocksizes[7] = { 64,128,256,512,1024,2048,4096 };
	micarray microphone_array_params;

};

