#include "packager.h"


packager::packager(char audioscene_geometry[], char microphonearray_geometry[],double* interleavedmultichannelaudio)
{	
	// parsing and serializing Audio Scene Geometry
	json j_complete = json::parse(audioscene_geometry);
	*BlockIndex = static_cast<double>(j_complete["BlockIndex"]);
	*BlockStart = static_cast<double>(j_complete["BlockStart"]);
	*BlockEnd = static_cast<double>(j_complete["BlockEnd"]);
	*SpeechCount = static_cast<unsigned char>(j_complete["SpeechCount"]);




	// parsing and serializing Microphone Array Geometry
	json j_complete_mag = json::parse(microphonearray_geometry);
	*BlockSize = blocksizes[static_cast<int>(j_complete_mag["BlockSize"])];
	*SamplingRate = samplingrates[static_cast<int>(j_complete_mag["SamplingRate"])];
	*SampleType = sampletypes[static_cast<int>(j_complete_mag["SampleType"])];

	for (int klm = 0; klm < *SpeechCount; klm++)
	{
		unsigned char* speechuuid; //;
		insertnewspeech(static_cast<double>(j_complete["SpeechList"][klm]["AzimuthDirection"]), 
						static_cast<double>(j_complete["SpeechList"][klm]["ElevationDirection"]), 
						static_cast<double>(j_complete["SpeechList"][klm]["Distance"]), 
						static_cast<unsigned char>(j_complete["SpeechList"][klm]["DistanceFlag"]), 
						(int)(*BlockSize), 
						interleavedmultichannelaudio, 
						static_cast<int>(j_complete["SpeechList"][klm]["ChannelID"]),
						speechuuid
			);
	}
	

};

void packager::insertnewspeech(double m_Azimuth, double m_Elevation, double m_Distance, unsigned char m_DistanceFlag,int m_blocksize,double* m_interleavedmultichannel, int ChannelID, unsigned char* uuid)
{
	SpeechInfo m_speech = SpeechInfo();

	*m_speech.Azimuth = m_Azimuth;
	*m_speech.Elevation = m_Elevation;
	*m_speech.Distance = m_Distance;
	*m_speech.DistanceFlag = m_DistanceFlag;


	m_speech.speechdata = m_interleavedmultichannel;
	Speech.push_back(m_speech);
};