#include "analysistransform.h"
#include "synthesistransform.h"
#include "soundfielddescription.h"


int main()
{
	int bloksize = 4096;
	int padding = 0;
	int total = bloksize + padding;
	analysistransform* m_fft = new analysistransform(2048, total,1024,2);
	synthesistransform* m_ifft = new synthesistransform(2048, total, 1024, 2);
	//soundfielddescription* m_shd = new soundfielddescription();

	double * signal = (double*)calloc(total *2, sizeof(double*));
	double* signal_out = (double*)calloc(total * 2, sizeof(double*));
	double*  realpart = (double*)calloc(total *2, sizeof(double*));
	double*  imagpart = (double*)calloc(total *2, sizeof(double*));
	for (int ch = 0; ch < 2; ch++)
	{
		for (int ik = 0; ik < total; ik++)
		{
			float degree = ((float)ik / (float)48000.0) * 2 * PI * 5000.0;
			if (ik >= padding)
				signal[ik*2 + ch] = 1* sin(degree);
			else
				signal[ik * 2 + ch] = 0.0;
		}
	}

	m_fft->FFT(signal, realpart, imagpart);
	m_ifft->IFFT(signal_out, realpart, imagpart);

	double average_error = 0.0;
		for (int klm = padding; klm < total; klm++)
		{
			average_error += abs(signal[klm * 2 + 1] - signal_out[klm * 2 + 1]);
			
		}
		printf("{%f}", average_error / bloksize);


		soundfielddescription sfd = soundfielddescription();


		char audioscenegeometry[] = R"(
		{
				"$schema": "http://json-schema.org/draft-07/schema#",
				"title" : "Audio Scene Geometry",
				"BlockIndex": ,
				"BlockStart" : ,
				"BlockEnd" : ,
				"SpeechCount" : 1,
				"SourceDetectionMask" : [],
				"SpeechList": [
						{"SpeechID" :  0.93358, "ChannelID" : 0.0, "AzimuthDirection" : 0.35836, "ElevationDirection" : 0.0, "DistanceFlag" : 0.93358, "Distance" : 0.0},
		
				],
				}
		)";


	return 0;
}
