#pragma once
#include <vector>

#include <nlohmann/json.hpp>

using namespace std;
using json = nlohmann::json;

class SpeechInfo
{
public:
	unsigned char Speechuuid[16];
	unsigned char Azimuth[4];
	unsigned char Elevation[4];
	unsigned char Distance[4];
	unsigned char DistanceFlag[1];
	double* speechdata;
};


class packager
{
public:
	packager(char audioscene_geometry[], char microphonearray_geometry[], double* interleavedmultichannelaudio);
	void insertnewspeech(double m_Azimuth, double m_Elevation, double m_Distance, unsigned char m_DistanceFlag, int m_blocksize, double* m_interleavedmultichannel, int ChannelID, unsigned char* uuid);
private:
	unsigned char Header[3] = {0x45,0x41,0x45};
	unsigned char BlockIndex[8];
	unsigned char BlockStart[8];
	unsigned char BlockEnd[8];
	unsigned char BlockSize[1];
	unsigned char SamplingRate[1];
	unsigned char SpeechCount[1];
	unsigned char SampleType[1];
	unsigned char Checksum[1];
	vector<SpeechInfo> Speech;
	int samplingrates[8] = { 16000,24000,32000,44100,48000,64000,96000,192000 };
	int sampletypes[3] = { 16,24,32 };
	int blocksizes[7] = { 64,128,256,512,1024,2048,4096 };
};

