# README #

This README would normally document whatever steps are necessary to get your application up and running.

### What is this repository for? ###

* Quick summary
	Analysis tranform is an AIM used for transferring the time domain microphone array signals into the frequency domain. This file introduces the setup for standalone application. 
* Version
	01.01.220708
* [Technical specifications MPAI-CAE v1.3](https://mpai.community/standards/resources/)

### How do I get set up? ###

* Summary of set up
	The development language is C++. C++11 or its newer versions support compiling the code. See the list of C++ compilers. (https://en.wikipedia.org/wiki/List_of_compilers#C++_compilers)
	This software uses a third-party fftw-3.3.9 that can be also downloaded from the link. (https://fftw.org/)
* Configuration
	Default constructor is configured through the following parameters. If these parameters are needed to be updated the alternative constructor can be set. 
	windowsize=2048, signallength=20480, hopsize=1024, nofmics=32
* Dependencies
	include : \include
    libs : 
	#if DEBUG
            \libs\Windows_x64\Debug;\libs\Windows_x86\Debug;\libs\Linux\Debug
	#else
            \libs\Windows_x64\Release;\libs\Windows_x86\Release;\libs\Linux\Release
	#endif	
* Database configuration
    This software doesnot use a database.
* How to run tests
	[Conformance Testing Document MPAI-CAE](https://mpai.community/standards/resources/)
* Deployment instructions
***********Standalone usage of this AIM (code script)
	// For analysis of 20480 samples with fftsize=2048 and overlap=1024
	// The output will be Interleaved Nofchannelsx10x1024 real and imaginary parts.
	// Input and output data formats can be followed from MPAI-CAE v1.3 
	 
	analysistransform* m_fft = new analysistransform();
	int NofChannels = 32;
	float* signal; // Data acquired from each microphone channel 
	float* realpart; // Real part to be malloc
	float* imagpart; // Imaginary part to be malloc

	for (int channel = 0; channel < NofChannels; channel++)
	{
		m_fft->STFT(signal, realpart+channel, imagpart+channel)
	}

### Who do I talk to? ###

* Repo owner or admin
	Mert Burkay Çöteli , mbcoteli@aselsan.com.tr, Aselsan
* Other community or team contact
	MPAI secreteriat , secretariat@mpai.community  , MPAI