#include "analysistransform.h"
#include "synthesistransform.h"
#include "soundfielddescription.h"
#include "packager.h"

int main()
{
	int bloksize = 4096;
	int padding = 0;
	int total = bloksize + padding;
	analysistransform* m_fft = new analysistransform(2048, total,1024,2);
	synthesistransform* m_ifft = new synthesistransform(2048, total, 1024, 2);
	//soundfielddescription* m_shd = new soundfielddescription();

	double * signal = (double*)calloc(total *2, sizeof(double*));
	double* signal_out = (double*)calloc(total * 2, sizeof(double*));
	double*  realpart = (double*)calloc(total *2, sizeof(double*));
	double*  imagpart = (double*)calloc(total *2, sizeof(double*));
	for (int ch = 0; ch < 2; ch++)
	{
		for (int ik = 0; ik < total; ik++)
		{
			float degree = ((float)ik / (float)48000.0) * 2 * PI * 5000.0;
			if (ik >= padding)
				signal[ik*2 + ch] = 1* sin(degree);
			else
				signal[ik * 2 + ch] = 0.0;
		}
	}

	m_fft->FFT(signal, realpart, imagpart);
	m_ifft->IFFT(signal_out, realpart, imagpart);

	double average_error = 0.0;
		for (int klm = padding; klm < total; klm++)
		{
			average_error += abs(signal[klm * 2 + 1] - signal_out[klm * 2 + 1]);
			
		}
		printf("{%f}", average_error / bloksize);


		


		char audioscenegeometry[] = R"(
		{
				"$schema": "http://json-schema.org/draft-07/schema#",
				"title" : "Audio Scene Geometry",
				"BlockIndex": 1,
				"BlockStart" : 1659533438878,
				"BlockEnd" : 1659533438898,
				"SpeechCount" : 1,
				"SourceDetectionMask" : [1,1,1],
				"SpeechList": [
								{"SpeechID" :  "09859d16-3c73-4bb0-9c74-91b451e34925", "ChannelID" : 0.0, "AzimuthDirection" : 0.35836, "ElevationDirection" : 0.0, "DistanceFlag" : 0.93358, "Distance" : 0.0}
							  ]
		}

		)";


		char microphonearraygeometry[] = R"(
		{
			"$schema": "http://json-schema.org/draft-07/schema#",
			"title": "Microphone Array Geometry",
			"MicrophoneArrayType": 0,
			"MicrophoneArrayScat": 0,
			"MicrophoneArrayFilterURI": "filter.file",
			"SamplingRate": 4,
			"SampleType": 2,
			"BlockSize": 5,
			"NumberofMicrophones": 32,
			"MicrophoneList" : [
					{"xCoord" :  0.93358,"yCoord" : 0.0,"zCoord" : 0.35836,"directivity" : 0.0,"micxLookCoord" : 0.93358,"micyLookCoord" : 0.0,"miczLookCoord" : 0.35836},
					{"xCoord" :  0.84804,"yCoord" : 0.52991,"zCoord" : 0.0,"directivity" : 0.0,"micxLookCoord" : 0.84804,"micyLookCoord" : 0.52991,"miczLookCoord" : 0.0},
					{"xCoord" :  0.93358,"yCoord" : 0.0,"zCoord" : -0.35836,"directivity" : 0.0,"micxLookCoord" : 0.93358,"micyLookCoord" : 0.0,"miczLookCoord" : -0.35836},
					{"xCoord" :  0.84804,"yCoord" : -0.52991,"zCoord" : 0.0,"directivity" : 0.0,"micxLookCoord" : 0.84804,"micyLookCoord" : -0.52991,"miczLookCoord" : 0.0},
					{"xCoord" :  0.52991,"yCoord" : 0.0,"zCoord" : 0.84804,"directivity" : 0.0,"micxLookCoord" : 0.52991,"micyLookCoord" : 0.0,"miczLookCoord" : 0.84804},
					{"xCoord" :  0.57922,"yCoord" : 0.57922,"zCoord" : 0.57357,"directivity" : 0.0,"micxLookCoord" : 0.57922,"micyLookCoord" : 0.57922,"miczLookCoord" : 0.57357},
					{"xCoord" :  0.35836,"yCoord" : 0.93358,"zCoord" : 0.0,"directivity" : 0.0,"micxLookCoord" : 0.35836,"micyLookCoord" : 0.93358,"miczLookCoord" : 0.0},
					{"xCoord" :  0.57922,"yCoord" : 0.57922,"zCoord" : -0.57357,"directivity" : 0.0,"micxLookCoord" : 0.57922,"micyLookCoord" : 0.57922,"miczLookCoord" : -0.57357},
					{"xCoord" :  0.52991,"yCoord" : 0.0,"zCoord" : -0.84804,"directivity" : 0.0,"micxLookCoord" : 0.52991,"micyLookCoord" : 0.0,"miczLookCoord" : -0.84804},
					{"xCoord" :  0.57922,"yCoord" : -0.57922,"zCoord" : -0.57357,"directivity" : 0.0,"micxLookCoord" : 0.57922,"micyLookCoord" : -0.57922,"miczLookCoord" : -0.57357},
					{"xCoord" :  0.35836,"yCoord" : -0.93358,"zCoord" : 0.0,"directivity" : 0.0,"micxLookCoord" : 0.35836,"micyLookCoord" : -0.93358,"miczLookCoord" : 0.0},
					{"xCoord" :  0.57922,"yCoord" : -0.57922,"zCoord" : 0.57357,"directivity" : 0.0,"micxLookCoord" : 0.57922,"micyLookCoord" : -0.57922,"miczLookCoord" : 0.57357},
					{"xCoord" :  -0.00625,"yCoord" : 0.35831,"zCoord" : 0.93358,"directivity" : 0.0,"micxLookCoord" : -0.00625,"micyLookCoord" : 0.35831,"miczLookCoord" : 0.93358},
					{"xCoord" :  0.0,"yCoord" : 0.84804,"zCoord" : 0.52991,"directivity" : 0.0,"micxLookCoord" : 0.0,"micyLookCoord" : 0.84804,"miczLookCoord" : 0.52991},
					{"xCoord" :  0.0,"yCoord" : 0.85716,"zCoord" : -0.51503,"directivity" : 0.0,"micxLookCoord" : 0.0,"micyLookCoord" :  0.85716,"miczLookCoord" : -0.51503},
					{"xCoord" :  0.006254,"yCoord" : 0.35831,"zCoord" : -0.93358,"directivity" : 0.0,"micxLookCoord" : 0.006254,"micyLookCoord" : 0.35831,"miczLookCoord" : -0.93358},
					{"xCoord" :  -0.93358,"yCoord" : 0.0,"zCoord" : 0.35836,"directivity" : 0.0,"micxLookCoord" : -0.93358,"micyLookCoord" : 0.0,"miczLookCoord" : 0.35836},
					{"xCoord" :  -0.84804,"yCoord" : -0.52991,"zCoord" : 0.0,"directivity" : 0.0,"micxLookCoord" : -0.84804,"micyLookCoord" : -0.52991,"miczLookCoord" : 0.0},
					{"xCoord" :  -0.93358,"yCoord" : 0.0,"zCoord" : -0.35836,"directivity" : 0.0,"micxLookCoord" : -0.93358,"micyLookCoord" : 0.0,"miczLookCoord" : -0.35836},
					{"xCoord" :  -0.84804,"yCoord" : 0.52991,"zCoord" : 0.0,"directivity" : 0.0,"micxLookCoord" : -0.84804,"micyLookCoord" : 0.52991,"miczLookCoord" : 0.0},
					{"xCoord" :  -0.52991,"yCoord" : 0.0,"zCoord" : 0.84804,"directivity" : 0.0,"micxLookCoord" : -0.52991,"micyLookCoord" : 0.0,"miczLookCoord" : 0.84804},
					{"xCoord" :  -0.57922,"yCoord" : -0.57922,"zCoord" : 0.57357,"directivity" : 0.0,"micxLookCoord" : -0.57922,"micyLookCoord" : -0.57922,"miczLookCoord" : 0.57357},
					{"xCoord" :  -0.35836,"yCoord" : -0.93358,"zCoord" : 0.0,"directivity" : 0.0,"micxLookCoord" : -0.35836,"micyLookCoord" : -0.93358,"miczLookCoord" : 0.0},
					{"xCoord" :  -0.57922,"yCoord" : -0.57922,"zCoord" : -0.57357,"directivity" : 0.0,"micxLookCoord" : -0.57922,"micyLookCoord" : -0.57922,"miczLookCoord" : -0.57357},
					{"xCoord" :  -0.52991,"yCoord" : 0.0,"zCoord" : -0.84804,"directivity" : 0.0,"micxLookCoord" : -0.52991,"micyLookCoord" : 0.0,"miczLookCoord" : -0.84804},
					{"xCoord" :  -0.57922,"yCoord" : 0.57922,"zCoord" : -0.57357,"directivity" : 0.0,"micxLookCoord" : -0.57922,"micyLookCoord" : 0.57922,"miczLookCoord" : -0.57357},
					{"xCoord" :  -0.35836,"yCoord" : 0.93358,"zCoord" : 0.0,"directivity" : 0.0,"micxLookCoord" : -0.35836,"micyLookCoord" : 0.93358,"miczLookCoord" : 0.0},
					{"xCoord" :  -0.57922,"yCoord" : 0.57922,"zCoord" : 0.57357,"directivity" : 0.0,"micxLookCoord" : -0.57922,"micyLookCoord" : 0.57922,"miczLookCoord" : 0.57357},
					{"xCoord" :  -0.00625,"yCoord" : -0.35831,"zCoord" : 0.93358,"directivity" : 0.0,"micxLookCoord" : -0.00625,"micyLookCoord" : -0.35831,"miczLookCoord" : 0.93358},
					{"xCoord" :  0.0,"yCoord" : -0.84804,"zCoord" : 0.52991,"directivity" : 0.0,"micxLookCoord" : 0.0,"micyLookCoord" : -0.84804,"miczLookCoord" : 0.52991},
					{"xCoord" :  0.0,"yCoord" : -0.84804,"zCoord" : -0.52991,"directivity" : 0.0,"micxLookCoord" : 0.0,"micyLookCoord" : -0.84804,"miczLookCoord" : -0.52991},
					{"xCoord" :  0.00625,"yCoord" : -0.35831,"zCoord" : -0.93358,"directivity" : 0.0,"micxLookCoord" : 0.00625,"micyLookCoord" : -0.35831,"miczLookCoord" : -0.93358}
				],
			 "MicrophoneArrayLookCoord" : {"xLookCoord" : 0.0, "yLookCoord" : 0.0, "zLookCoord" : 0.0}
		}
     )";

		soundfielddescription sfd = soundfielddescription(microphonearraygeometry);


		int msgsize = 0;
		packager m_packager;
		unsigned char* result = m_packager.createdata(audioscenegeometry, microphonearraygeometry, signal_out, &msgsize);

	return 0;
}
