#pragma once

#include <string> 
#include <vector>
#include <complex>

#define PI 3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068

enum class ArrayType_sds
{
	Spherical,
	Circular,
	Planar,
	Linear,
	Other
};

enum class ArrayScattering_sds
{
	Rigid,
	Open,
	OtherArray
};

using namespace std;
class micarray_sds
{
public:
	micarray_sds();
	vector<float> getmicthetas();
	vector<float> getmicphis();
	void addnewmicrophone(float mic_x,float mic_y,float mic_z, float mic_ld_x, float mic_ld_y, float mic_ld_z,float ma_x,float ma_y,float ma_z);
private:
	void ConvertCartesionToSpherical(float& distance, float& theta, float& phi, float& x, float& y, float& z);
	void ConvertSphericalToCartesian(float& distance, float& theta, float& phi, float& x, float& y, float& z);
	int numberofmicrophones;
	vector<float> microphonetheta;
	vector<float> microphonephi;
	vector<float> microphonedistance;
	vector<float> microphone_x;
	vector<float> microphone_y;
	vector<float> microphone_z;
};

