
#include "cuda_runtime.h"
#include "device_launch_parameters.h"

#include <stdio.h>
#include <math.h>
#include <chrono>



cudaError_t addWithCuda(int* c, const int* a, const int* b, unsigned int size);
cudaError_t multiplyWithCuda(float* c, float* a, float* b, unsigned int size);
cudaError_t ComplexmultiplyWithCuda(float* c, float* c_im, float* a, float* b, float* a_im, float* b_im, unsigned int size);
cudaError_t Device_DComplexmultiplyWithCuda(float* dev_c, float* dev_c_im, float* dev_a, float* dev_b, float* dev_a_im, float* dev_b_im, unsigned int micsize, unsigned int tfheight, unsigned int size, unsigned int BlockSize, unsigned int freqstart, unsigned int legendresamples, float* dev_kr_matrix);
cudaError_t Device_DmultiplyWithCuda(float* dev_c, float* dev_c_im, float* dev_a, float* dev_b, float* dev_a_im, unsigned int freqanalysiswindow, unsigned int BlockSize, unsigned int tfheight, unsigned int freqstart, unsigned int legendresamples,float* dev_kr_matrix);
cudaError_t AddWithCuda(float* c, float* c_im, float* a, float* b, float* a_im, float* b_im, unsigned int size);
cudaError_t SubtractWithCuda(float* c, float* c_im, float* a, float* b, float* a_im, float* b_im, unsigned int size);
cudaError_t Device_SubtractWithCuda(float* dev_c, float* dev_c_im, float* dev_a, float* dev_b, float* dev_a_im, float* dev_b_im, unsigned int size);
cudaError_t Device_AddWithCuda(float* dev_c, float* dev_c_im, float* dev_a, float* dev_b, float* dev_a_im, float* dev_b_im, unsigned int size);
cudaError_t Device_GetHistogram(float* dev_next, float* dev_next_im, float* dev_a, unsigned int freqanalysis, unsigned int legendresamples, unsigned int BlockSize);
cudaError_t RescomplexmatrixMultiplicationKernel(float* c, float* c_im, float* a, float* b, float* a_im, float* hist, unsigned int freqnumber, unsigned int legendresamples, unsigned int BlockSize, float* dev_kr_matrix);
cudaError_t MagcomplexmatrixMultiplicationKernel(float* c, float* c_im, float* a, float* b, float* a_im, float* hist, unsigned int noffrequency, unsigned int legendresamples, unsigned int BlockSize, float* dev_kr_matrix);
cudaError_t Swapmatrices(float* c, float* c_im, float* a, float* a_im, unsigned int noffrequency, unsigned int BlockSize, unsigned int legendresamples);
cudaError_t Swapmatrices2D(float* c, float* c_im, float* a, float* a_im, unsigned int size, unsigned int BlockSize);
cudaError_t RENTHistogramKernel(float* c, float* c_im, float* a, float* a_im, float* hist, float* RENThist, unsigned int legendresamples, unsigned int BlockSize, unsigned int noffreqbins);
cudaError_t CalculateMultiplicationMatrices(float* dev_multiplication_kernel, float* dev_general_histogram, float* dev_kernels_vonmises, float* dev_kernels, unsigned int BlockSize, unsigned int size, unsigned int iterationcount);
cudaError_t OMPSeparatedSources(float* dev_result, float* dev_result_im, float* dev_multiplication_kernel, float* dev_multiplication_kernel_imag, float* dev_magnitudes, float* dev_magnitudes_im, float* dev_general_histogram, unsigned int BlockSize, unsigned int legendresamples, unsigned int NofFrequencyBins, unsigned int WindowLength, unsigned int nofiterations, float* sourcedoa, unsigned int nofsources,float* dev_pressurelevel,float* dev_krmatrix);
