#include "micarray.h"

micarray::micarray()
{
    this->numberofmicrophones = 32;
}

vector<float> micarray::getmicthetas()
{

    return microphonetheta;
}
vector<float> micarray::getmicphis()
{

    return microphonephi;
}

void micarray::addnewmicrophone(float mic_x, float mic_y, float mic_z, float mic_ld_x, float mic_ld_y, float mic_ld_z, float ma_x, float ma_y, float ma_z)
{
    float x = mic_x ;
    float y = mic_y ;
    float z = mic_z ;

    float microphone_phi;
    float microphone_theta;
    float microphone_distance;

    microphone_x.push_back(x);
    microphone_y.push_back(y);
    microphone_z.push_back(z);

    ConvertCartesionToSpherical(microphone_distance, microphone_theta, microphone_phi, x, y, z);

    microphonetheta.push_back(microphone_theta);
    microphonephi.push_back(microphone_phi);
    microphonedistance.push_back(microphone_distance);
}

void micarray::ConvertCartesionToSpherical(float& distance, float& theta, float& phi, float& x, float& y, float& z)
{

    phi = atan2(y , x);

    if (phi < 0.0)
        phi += 2.0 *PI;

    theta = atan2(sqrt(x * x + y * y) , z);

    if (theta < 0.0)
        theta += 1.0 * PI;
    distance = sqrt(x * x + y * y + z * z);

}

void micarray::ConvertSphericalToCartesian(float& distance, float& theta, float& phi, float& x, float& y, float& z)
{

    x = distance * sin(theta) * cos(phi);
    y = distance * sin(theta) * sin(phi);
    z = distance * cos(theta);

}