#include "packager.h"
/*
Audio Scene Geometry : jsonformat
Microphone Array Geometry : jsonformat
Denoised Speech : Interleaved multichannel Audio

Speech1 ----- Speech2 ----- Speech3 ----- SpeechN
Sample11,Sample21,Sample31...SampleK1 ----- Sample12,Sample22,Sample32...SampleK2 ----- Sample1N,Sample2N,Sample3N...SampleKN 

*/
// Constructor for the packager object
packager::packager()
{	

	
};
// Create message array for the block
unsigned char* packager::createdata(char audioscene_geometry[], char microphonearray_geometry[], double* interleavedmultichannelaudio,int* messagesize)
{

	// deserializing Audio Scene Geometry json file
	json j_complete = json::parse(audioscene_geometry);
	double BlockIndex = (double)static_cast<int>(j_complete["BlockIndex"]);
	double BlockStart = (double)static_cast<int>(j_complete["BlockStart"]);
	double BlockEnd = (double)static_cast<int>(j_complete["BlockEnd"]);
	unsigned char SpeechCount = static_cast<unsigned char>(j_complete["SpeechCount"]);



	// deserializing Microphone Array Geometry json file
	json j_complete_mag = json::parse(microphonearray_geometry);
	unsigned char BlockSize = static_cast<unsigned char>(j_complete_mag["BlockSize"]);
	unsigned char SamplingRate = static_cast<unsigned char>(j_complete_mag["SamplingRate"]);
	unsigned char SampleType = static_cast<unsigned char>(j_complete_mag["SampleType"]);


	int BlockSze = static_cast<int>(blocksizes[j_complete_mag["BlockSize"]]);
	total_msgsize = 32 + (SpeechCount) * (32 + 8 * BlockSze);

	int Sampletpe = static_cast<int>(sampletypes[j_complete_mag["SampleType"]]);

	// Allocation of the output array
	packagedcontent = (unsigned char*)calloc(sizeof(unsigned char), total_msgsize);

	// Mem copy for the pointer addresses
	memcpy(packagedcontent, &"EAE", 3 * sizeof(unsigned char));
	memcpy(packagedcontent + 3, &BlockIndex, 8 * sizeof(unsigned char));
	memcpy(packagedcontent + 11, &BlockStart, 8 * sizeof(unsigned char));
	memcpy(packagedcontent + 19, &BlockEnd, 8 * sizeof(unsigned char));
	memcpy(packagedcontent + 27, &BlockSize, 1 * sizeof(unsigned char));
	memcpy(packagedcontent + 28, &SamplingRate, 1 * sizeof(unsigned char));
	memcpy(packagedcontent + 29, &SpeechCount, 1 * sizeof(unsigned char));
	memcpy(packagedcontent + 30, &SampleType, 1 * sizeof(unsigned char));


	// Checksum for the message Header
	int sum = 0;
	
	for (int ind = 0; ind < 31; ind++){ sum += *(packagedcontent + ind);}

	*(packagedcontent + 31) = sum % 256;


	// For each speech object, place the denoised speech to the message
	for (int klm = 0; klm < SpeechCount; klm++)
	{
		int speech_index = klm * (int)(BlockSze);
		int messagedata_index = 32 + klm * (32 + 8 * BlockSze);
		string s_uuid = j_complete["SpeechList"][klm]["SpeechID"];
		insertnewspeech(static_cast<double>(j_complete["SpeechList"][klm]["AzimuthDirection"]),
			static_cast<double>(j_complete["SpeechList"][klm]["ElevationDirection"]),
			static_cast<double>(j_complete["SpeechList"][klm]["Distance"]),
			static_cast<unsigned char>(j_complete["SpeechList"][klm]["DistanceFlag"]),
			(int)(BlockSze),
			interleavedmultichannelaudio + speech_index,
			static_cast<int>(j_complete["SpeechList"][klm]["ChannelID"]),
			s_uuid,
			packagedcontent + messagedata_index,
			Sampletpe / 4
		);
	}

	*messagesize = total_msgsize;

	return packagedcontent;
}

// Insert speech data into array
void packager::insertnewspeech(float m_Azimuth, float m_Elevation, float m_Distance, unsigned char m_DistanceFlag,int m_blocksize,double* m_interleavedmultichannel, int ChannelID, string uuid, unsigned char* in_array, int samplebytes)
{
	// Speech Information Header
	memcpy(in_array, &uuid, 16 * sizeof(unsigned char));
	memcpy(in_array + 16,  &m_Azimuth, 4 * sizeof(unsigned char));
	memcpy(in_array + 20,  &m_Elevation, 4 * sizeof(unsigned char));
	memcpy(in_array + 24,  &m_Distance, 4 * sizeof(unsigned char));
	memcpy(in_array + 28,  &m_DistanceFlag, 1 * sizeof(unsigned char));

	// Speech Header 
	int sum = 0;
	for (int ind = 0; ind < 30; ind++){ sum += *(in_array + ind); }
	*(in_array +31) = sum %256;

	memcpy(in_array + 32, m_interleavedmultichannel, m_blocksize * sizeof(unsigned char) * samplebytes);
	
};
