#define _USE_MATH_DEFINES
#include <cmath>
#include <nlohmann/json.hpp>
#include "kernel_noisecancel.cuh"
#include "healpixkernel_nc.h"

#define HEALPixOrder 2
#define MaxSphericalHarmonicsOrder 4

using json = nlohmann::json;

#pragma once

	

struct complex_num_out {
	const float* real = 0;
	const float* imag = 0;
};

class noisecancellation
{

public:
	noisecancellation(int windowsize, int blocksize);
	void getwienermatrices(json audioscenegeometry);
	complex_num_out Operate_NoiseCancellation(void* srf_multiplier, void* srf_multiplier_im,void* separated_sources, void* separated_sources_im);
private:

	healpixkernel_nc* hp_kernel;
	float* magkernels;
	float* pinv_multiplier = 0;

	unsigned int AudioBlockSize;
	unsigned int NofFrequency;
	unsigned int nofsources;
	unsigned int NofSamples;

	// GPU device malloc parameters
	const float* dev_pinv_multiplier = 0;
	const float* dev_covariance = 0;
	const float* dev_multip = 0;
	const float* dev_multip_im = 0;

	const float* SRF_multiplier = 0;
	const float* dev_sum_tfmultiplier = 0;
};

