#include "utility.hpp"

using namespace std;
namespace fs = std::filesystem;
using json = nlohmann::json;

Threshold::Threshold(float percentual, int angle, int scale, int pos) {
    if (percentual < 0 || percentual > 100) throw std::invalid_argument("Percentual must be between 0 and 100");

    this->percentual = percentual;
    this->angle = angle;
    this->scale = scale;
    this->pos = pos;
}

SceneObject::SceneObject(int minDist, Threshold threshold) {
    this->minDist = minDist;
    this->threshold = threshold;
}

SceneObject SceneObject::from_file(fs::path path, ROI obj) {
    ifstream iConfig(path);
    json j;
    iConfig >> j;

    if (obj == ROI::TAPE) {
        return SceneObject(j["MinDist"],
                           Threshold(j["TapeThresholdPercentual"], j["AngleThresh"], j["ScaleThresh"], j["PosThresh"]));
    } else {
        return SceneObject(j["MinDistCapstan"], Threshold(j["CapstanThresholdPercentual"], j["AngleThreshCapstan"],
                                                          j["ScaleThreshCapstan"], j["PosThreshCapstan"]));
    }
}