/**
 * @file files.hpp
 * @author Matteo Spanio (dev2@audioinnova.com)
 * @brief A collection of functions to handle files.
 * @version 1.0
 * @date 2023-05-13
 *
 * @copyright Copyright (c) 2023
 *
 */

#ifndef FILES_H
#define FILES_H
#include <stdlib.h>

#include <filesystem>
#include <fstream>
#include <iostream>
#include <string>

/**
 * @namespace files
 * @brief A collection of functions to handle files.
 *
 */
namespace files {
/**
 * @fn void save_file(std::filesystem::path fileName, std::string content)
 * @brief Save content to a file
 *
 * @param fileName the name of the file
 * @param content the content to be saved
 */
void save_file(std::filesystem::path fileName, std::string content);

/**
 * @fn void findFileNameFromPath(std::string* path, std::string* fileName,
 * std::string* extension)
 * @brief Separates video file name from its extension.
 *
 * @param[in] path Full video path;
 * @param[out] fileName Video file name;
 * @param[out] extension Video extension.
 */
void findFileNameFromPath(std::string* path, std::string* fileName, std::string* extension);

/**
 * @fn std::pair<std::string, std::string> findFileName(std::string videoPath)
 * @brief Check if the specified input video file exists and is supported.
 *
 * @param videoPath Full video path;
 * @return a pair of strings containing the video file name and its extension.
 */
std::pair<std::string, std::string> get_filename_and_extension(std::string videoPath);
}  // namespace files
#endif  // FILES_H