#ifndef FORAUDIOANALYSER_H
#define FORAUDIOANALYSER_H
#include <filesystem>
#include <iostream>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgcodecs.hpp>
#include <opencv2/imgproc.hpp>
#include <nlohmann/json.hpp>
#include <boost/uuid/uuid.hpp>
#include <boost/uuid/uuid_generators.hpp>

#include "lib/time.hpp"
#include "lib/core.hpp"

using namespace cv;
using namespace std;
using json = nlohmann::json;
namespace fs = std::filesystem;
namespace va = videoanalyser;

const string G_IMG_FOLDER_PATH = "fromAudioAnalyser";

va::Result<int> extract_irregularity_images_for_audio(std::string output_path, const std::string video_path,
                                           json irregularity_file_input, json &irregularity_file_output) {
    // Make fromAudioAnalyser folder
    int caps_directory = fs::create_directory(output_path + G_IMG_FOLDER_PATH + "/");

    // Open video
    cv::VideoCapture videoCapture(video_path);

    // Compute video length in milliseconds
    int fps = videoCapture.get(CAP_PROP_FPS);

    for (int i = 0; i < irregularity_file_input["Irregularities"].size(); i++) {
        // Declare output image frame
        cv::Mat frame;
        std::string frame_path;
        // Extract TimeLabel from input JSON
        std::string time_label = irregularity_file_input["Irregularities"][i]["TimeLabel"];
        int irr_time_in_ms = time_label_to_ms(time_label);

        std::string safe_time_label = getTimeLabel(irr_time_in_ms, "-");

        // Compute the frame number corresponding to the Irregularity
        int irr_frame = std::round((float)(irr_time_in_ms / 1000) * fps);

        try {
            frame_path = output_path + G_IMG_FOLDER_PATH + "/AudioIrregularity_" + safe_time_label + ".jpg";
            videoCapture.set(CAP_PROP_POS_FRAMES, irr_frame);
            videoCapture >> frame;
            cv::imwrite(frame_path, frame);

            // Append Irregularity information to JSON
            boost::uuids::uuid uuid = boost::uuids::random_generator()();
            irregularity_file_output["Irregularities"] +=
                {{"IrregularityID", irregularity_file_input["Irregularities"][i]["IrregularityID"]},
                 {"Source", "a"},
                 {"TimeLabel", time_label},
                 {"ImageURI", frame_path}};
        } catch (cv::Exception e) {
            return va::Error("TimeLabel error for Audio Analyser Irregularity " + i);
        }
    }
    return va::Result<int>(0);
}
#endif  // FORAUDIOANALYSER_H