# Prima implementazione

L’applicativo realizzato è in grado di scorrere l’intero video estrapolandone ogni frame ed elaborandolo per determinare la presenza, o meno, di qualcosa di interessante. L’idea è di catturare una particolarità che compare in un frame e che non è presente in quello precedente. Per realizzare questo si è utilizzato lo strumento del BackgroundSubtractorKNN che esegue una separazione del foreground dal background in base ai vari frame che sono stati forniti come input; si basa quindi sullo storico di quanto visto per separare gli elementi nuovi da quelli ricorrenti. Si è notato che, memorizzando i frame in cui il foreground presentava anche un solo elemento, venivano salvate molte immagini in cui si rilevavano piccole variazioni di luminosità, lo scorrere del nastro nella bobina presente nello sfondo, eccetera; tutte queste rilevazioni non sono ritenute interessanti e, per questo motivo, si è dovuto modificare l’approccio.

Quanto rilevato, anche se erroneamente, ha delle caratteristiche comuni:
- rimane nella stessa posizione rispetto al frame precedente;
- non scorre orizzontalmente;
- nella maggior parte dei casi sono insiemi di punti piccoli rispetto alla grandezza delle discontinuità.

Sono stati quindi analizzati i punti che venivano rilevati nel foreground e considerati solo quelli che risultano di dimensioni rilevanti (l’altezza almeno 1/12 delle righe del frame e al massimo 1/3); in questo modo sono stati eliminati tutti i falsi positivi che venivano segnalati e che in realtà non rappresentavano nulla di interessante. Successivamente si sono memorizzate solamente le particolarità che scorrono orizzontalmente (che si trovano sul nastro da analizzare): pensando di avere una linea verticale a 2/3 dell’immagine si sono analizzati i punti rilevati nel foreground che hanno dimensioni rilevanti e attraversano tale confine. In questo modo, tutto ciò che viene segnalato, scorre orizzontalmente lungo il nastro e ha dimensioni ragguardevoli. Grazie a questa prima versione dell’algoritmo si è riusciti ad analizzare il nastro magnetico rilevando delle particolarità con dimensioni rilevanti: piccoli tratti di nastro rovinato, segni e brevi scritte non vengono rilevate ma vengono direttamente scartate. Un altro problema di quest’algoritmo è il tempo di esecuzione particolarmente elevato dovuto all’utilizzo del BackgroundSubtractorKNN; non si è potuto migliorare questo fattore poichè dipendente solamente dalla libreria utilizzata. Le successive modifiche dell’algoritmo sono nate dalla necessità di rilevare anche queste piccole discontinuità (vista l’importanza per lo scopo del progetto) e per rendere i tempi di esecuzione più rapidi.

# Seconda implementazione

Nella seconda versione dell’algoritmo si è cercato il modo di rilevare automaticamente la zona relativa al nastro utilizzando il sistema precedentemente sviluppato: analizzando i vari frame, rilevando al massimo 7 discontinuità e memorizzando i bound del rect che la circondano si è cercato di stimare le dimensioni del nastro. Per il bound delle x (destro e sinistro) si è calcolata la media tra i valori rilevati mentre, per il bound delle y, si è preso il valore minimo per il limite superiore e massimo per quello inferiore. La scelta è data dalla presenza di discontinuità più piccole a cui si deve dare meno peso per determinare l’area del nastro; nella Fig.3.1, ad esempio, si nota come le due discontinuità debbano assumere peso diverso nel calcolo del bound inferiore e superiore, essendo soprattutto la seconda un falso positivo.

Dopo aver rilevato il posizionamento del nastro non viene più utilizzato il BackgroundSubtractorKNN riducendo notevolmente il tempo di esecuzione dell’algoritmo. Per verificare la presenza o meno di particolarità nel nuovo frame rispetto al precedente si utilizza l’operatore - . Vengono analizzati i pixel, nell’area individuata in precedenza, del frame risultante da tale operazione: se il numero di pixel non neri, e quindi differenti nei due frame, supera una certa soglia allora il frame viene valutato come interessante e salvato; viceversa non viene considerato. Si è testato questo algoritmo su diversi video, verificando che rileva molte più discontinuità rispetto alle situazioni precedenti ma anche dei falsi positivi. Un problema riscontrato durante i test, come si può vedere in Fig.3.2, è che in caso di discontinuità tra nastro giallo e bianco (più in generale tra nastri di colorazioni simili), il frame risultante dalla differenza non presenta abbastanza punti per superare il threshold impostato.

Per risolvere il problema si è eseguita la differenza tra i frame manualmente. Si analizzano pixel per pixel le due immagini e si confrontano i valori dei canali RGB; se tutti e 3 i valori risultano uguali allora il pixel nella nuova immagine viene colorato in bianco, altrimenti in nero. Vengono conteggiati, in un segmento del nastro magnetico, il numero di pixel di colorazione bianca; se il numero è inferiore alla soglia impostata l’immagine viene considerata interessante, altrimenti no. Con questa nuova modifica si è migliorato notevolmente il numero corretto di discontinuità rilevate, riducendo anche i falsi positivi presenti.

Controllando i bound che l’algoritmo determina automaticamente, si è riscontrato che in molti video essi non sono corretti per via di discontinuità errate che vengono rilevate e utilizzate per il calcolo. Si è deciso quindi di procedere aggiustando manualmente i bound delle y per ogni video da analizzare; il lavoro manuale aumenta notevolmente ma si evitano errori di questo genere. Una delle note positive di questa lavorazione è che, come si può vedere dalle Tab.3.1 - 3.2, i tempi di elaborazione si riducono notevolmente rilevando comunque quanto desiderato.

## Problema dell'interlacciamento

Una delle problematiche riscontrate nei frame salvati dall’algoritmo è stato il fenomeno dell’interlacciamento (interlacing). L’interlacciamento è un sistema di scansione video che prevede la divisione in linee pari e dispari dette rispettivamente semiquadri. Il motivo per cui, storicamente, lo si è utilizzato è perchè permette una qualità migliore di trasmissione senza bisogno di aumentare la larghezza di banda. Grazie a questa tecnica si arriva a visualizzare un unico frame di un video come due "mezzi" frame acquisiti in momenti diversi. Esaminando il singolo fotogramma, nelle zone in movimento si nota che le righe dispari e pari risultano disallineate (Fig.3.3).

## Soluzione al problema dell'interlacciamento

Sono state studiate e testate varie tecniche per la risoluzione del problema dell’interlacciamento dei frame ( e.g. Fig.3.3 ); nel seguito sono elencate le strategie studiate e gli esiti della loro applicazione.

Una delle tecniche più utilizzate da software specifici per la riproduzione video (quale VLC) è la separazione dei due semiquadri nel frame analizzato. Questo consiste nel creare due immagini (una relativa alle righe dispari e una alle righe pari) partendo dal frame originale; queste due immagini sono appunto chiamate semiquadro dispari e pari rispettivamente. Utilizzando uno solo dei due semiquadri si perde metà contenuto informativo del frame in questione. In Fig.3.4 si possono vedere i due semiquadri ottenuti dall’immagine iniziale. Se si volesse un’immagine finale della stessa dimensione di quella iniziale allora si può utilizzare la tecnica bob, che consiste nella duplicazione di ogni riga del semiquadro.

# Terza implementazione

In [12] viene presentato un primo software per l’elaborazione dei video e l’estrazione automatica dei frame ritenuti interessanti. Sviluppato in C++, con l’utilizzo della libreria OpenCV, l’applicativo analizza un intero video, estrapolando ogni singolo fotogramma ed elaborandolo per determinare la presenza o meno di una discontinuità.
Poiché, per tale lavoro, la zona interessante del video è il nastro, l’algoritmo cerca di rilevare in maniera automatica la sua posizione all’interno del frame. In un primo step il software individua approssimatamente la zona di interesse basandosi sul fatto che il nastro si trova sempre a circa due terzi dell’immagine dal margine superiore; in seguito cerca di affinare la stima rilevando alcune discontinuità e calcolando i bound del rettangolo che la circondano: per le ascisse si è calcolata la media dei valori rilevati, mentre per le ordinate si è preso il limite superiore e quello inferiore.

Una volta individuata la zona del nastro, l’algoritmo va ad analizzare e comparare i frame a due a due consecutivi nell’area selezionata dai bound. Confrontando i tre canali RGB, calcola il numero di pixel diversi; se tale numero supera una certa soglia (definita come percentuale rispetto alla grandezza del rettangolo in analisi), allora il frame è considerato interessante e viene salvato, altrimenti tralasciato. Poichè la videocamera utilizzata registra in standard PAL (Phase Alternating Line), l’immagine estrapolata è soggetta al fenomeno dell’interlacciamento, per il quale ogni fotogramma viene suddiviso in due semiquadri, formati dalle righe dispari e da quelle pari. Questa tecnica permette all’occhio umano di percepire una qualità di visualizzazione migliore senza bisogno di aumentare la larghezza di banda della trasmissione. Di conseguenza però, al momento dell’estrapolazione del frame, le righe pari e quelle dispari degli oggetti in movimento non risultano allineate (come visibile dalla giunta che scorre in figura 2.5); tale problema è stato risolto salvando solo il semiquadro formato dalle righe dispari, ottenendo quindi immagini con una risoluzione 720x228.

## Problematiche riscontrate

L’algoritmo presentato riesce a rilevare buona parte delle discontinuità, ma sono state riscontrate alcune problematiche, sulle quali si è deciso di intervenire (come spiegato in sez. 3.2).

In primo luogo, controllando i bound che l’algoritmo determina automaticamente per rilevare l’area del nastro su cui effettuare l’analisi, si è riscontrato che in molti video essi non sono corretti. È pertanto necessario aggiustarli manualmente, modificando le coordinate dell’ordinata direttamente nel file XML di configurazione (codice 2.1). Tale operazione aumenta notevolmente il lavoro dell’utente e si rivela essere un procedimento molto scomodo, poco preciso e facilmente soggetto a errori: bisogna infatti effettuare dei tentativi cambiando le coordinate fino a quando il rettangolo che individua l’area da analizzare è posizionato correttamente sul nastro, sia come dimensioni che come localizzazione (fig. 2.6). L’altezza del rettangolo infatti non dipende solamente dalla larghezza del nastro, ma anche dal posizionamento della videocamera, che non è fissa rispetto al magnetofono; pertanto non è detto che la stessa altezza del rettangolo sia riutilizzabile per diversi video.

In secondo luogo, per ogni discontinuità che passa sul nastro, l’algoritmo salva in media 3 immagini (quando è in ingresso al frame, in posizione centrale e in uscita dal frame), arrivando però anche a 5 in caso di giunte particolarmente lunghe o presentanti scritte, aumentando notevolmente le dimensioni del dataset risultante.

In presenza di marche, rappresentanti il produttore, o in generale di stampe ripetute sul retro del nastro, l’algoritmo distingue ogni singolo frame come differente dal precedente. Quindi tali stampe vengono rilevate continuamente come qualcosa di particolare che deve essere notificato, generando un numero elevatissimo di immagini che di fatto non sono utili allo scopo del progetto. Anche modificando la soglia per discriminare i frame interessanti non si risolve il problema, in quanto si rischia di perdere frame con discontinuità rilevanti; ovviamente è preferibile salvare i falsi positivi (immagini che non risultano essere utili) piuttosto che avere falsi negativi, ovvero perdere informazioni importanti.

Infine, il software non rileva tutte le discontinuità; una delle problematiche più importanti è il fatto che spesso non rilevi l’evento “fine del nastro”. In particolare, questo punto di interesse viene rilevato solo nel caso in cui, nel momento in cui il nastro smette di scorrere tra le testine, si distacchi notevolmente dalla testina di lettura.

Nella tabella 2.1 vengono riportati i risultati relativi a due video acquisiti filmando lo stesso nastro, che è stato creato ad hoc per testare l’algoritmo. Dapprima è stato acquisito il video del nastro a una velocità di 15 ips (Esperimento5.mov) e successivamente a una velocità di 7.5 ips (Esperimento6.mov). Come possiamo notare, l’algoritmo salva moltissimi frame in più rispetto al numero di discontinuità individuate, poiché rileva numerose immagini relative alla stessa giunta e/o scritta che passa. L’algoritmo infine non rileva, per entrambe le velocità, due scritte e la fine del nastro.

 Video | Discontinuità trovate   | Discontinuità presenti | Frame salvati  
----------------|----------------|----------------|----------------
 Esperimento5 | 76 | 79 | 205      
 Esperimento6 | 76 | 79 | 283          

La tabella mostra i risultati dell'algoritmo di estrazione.

## Interventi apportati al software

Il primo problema che si è andati a risolvere è stato il metodo di selezione della ROI (Region Of Interest), per evitare che l’utente debba trovare e scrivere nel file di configurazione le coordinate numeriche esatte.

Si è optato per creare un’interfaccia con cui l’utente possa interagire e selezionare a piacimento l’area di interesse, lasciando la gestione numerica delle coordinate al software stesso. Prima di far partire l’analisi viene quindi visualizzato a schermo un frame del video, dove l’utente può disegnare un rettangolo per indicare all’applicazione la regione dove eseguire l’analisi dei pixel da confrontare; in caso di errori, l’area di tale rettangolo è modificabile. Una volta selezionata la ROI l’utente può far partire l’analisi, la cui logica è stata mantenuta dallo script originale. La costruzione del rettangolo è gestita tramite una funzione di callback per gli eventi del mouse (mouse handler), in ascolto sulla specifica finestra del frame, fino a quando questo non viene chiuso per far partire l’analisi.

Uno dei problemi di questo approccio è la variabilità delle dimensioni del rettangolo, in quanto lasciate decidere all’utente. Più grande è la regione di interesse più bassa dev’essere impostata la soglia per selezionare un frame interessante, altrimenti si rischierebbe di perdere le giunte o i segni più piccoli. Inoltre, è necessario disegnare la ROI in modo che non sia troppo piccola: la distanza percorsa dalla discontinuità tra due frame contigui potrebbe essere infatti maggiore della larghezza del rettangolo.

Dopo una serie di test su nastri e video differenti, si è notato che con una soglia impostata al 97% e l’area della ROI selezionata di altezza pari a quella del nastro e di larghezza calibrata sulla dimensione della testina di lettura (come mostrato in figura 3.2a) si ottengono risultati migliori rispetto al precedente algoritmo (sezione 3.3). Sarà ovviamente necessario istruire l’utente per ottenere i risultati desiderati combinando correttamente il valore della soglia e la dimensione del rettangolo.

In un secondo momento ci si è accorti che alcuni nastri non sono perfettamente allineati rispetto al piano orizzontale; per rendere l’analisi più precisa si è quindi introdotta la possibilità di ruotare la ROI sull’interfaccia: infatti più il rettangolo è calibrato sulla dimensione e sulla posizione del nastro, più l’analisi dei pixel condurrà a risultati precisi (figura 3.2b). L’utente può attivare l’inclinazione del rettangolo tramite il tasto Ctrl e ampliare o diminuire l’angolo di rotazione tramite trascinamento del mouse. Si è quindi modificato il codice della gestione della ROI per adattarla a tutti i possibili casi di rotazione del rettangolo.

Il secondo problema affrontato è stato quello del riconoscimento dell’evento “fine del nastro”. Come descritto in sezione 2.2.1, il software rileva tale istante solo se il nastro, una volta finito lo scorrimento, si distacca dalla testina di lettura. In molti casi però tale distacco non avviene; di conseguenza non vi sono modifiche visibili nell’area selezionata come regione di interesse e il frame non viene selezionato come interessante.
Si è cercato quindi un approccio diverso per risolvere il problema, considerando tutti gli elementi effettivamente visibili nel video. La videocamera, infatti, inquadra orizzontalmente il magnetofono, mostrando anche i meccanismi attraverso cui passa il nastro durante la riproduzione (figura 3.3). Di particolare interesse nel nostro caso sono risultati il capstan e il rullo pressore (pinch wheel), visibili in figura 3.4.

Il capstan è un perno rotante utilizzato per spostare il nastro attraverso i meccanismi e le testine magnetiche (di cancellazione, scrittura e lettura) del magnetofono. Durante la riproduzione infatti, il nastro passa attraverso il capstan e una ruota gommata, il rullo pressore: il secondo preme il nastro contro il primo, in modo da fornire l’attrito necessario affinchè il nastro continui a scorrere. Tipicamente il rullo pressore è situato dopo le testine magnetiche nella direzione del nastro in movimento (sulla destra del video nel caso in esame).
L’uso di tali meccanismi permette al nastro di scorrere uniformemente sulle testine, consentendo una velocità precisa e costante nella riproduzione; inoltre, sia il capstan che il rullo pressore devono essere sottoposti a una continua pulizia: qualsiasi irregolarità infatti può causare distorsioni nell’audio, come per esempio wow e flutter.
Nel momento in cui la riproduzione termina, il rullo rilascia il nastro allontanandosi dal capstan ed è per questo motivo che a volte il nastro esce dalla sede della testina di lettura. Il movimento del rullo pressore è ben visibile in tutti i video e per tale motivo si è scelto di fare affidamento su questo per rilevare l’istante di fine nastro.
È stata quindi introdotta la possibilità di selezionare una seconda regione di interesse, finalizzata a rilevare il suddetto movimento. L’analisi del rettangolo selezionato segue la stessa logica dell’analisi della prima ROI. Per non appesantire computazionalmente e per ridurre quindi i tempi di esecuzione, il controllo del secondo rettangolo selezionato viene però eseguito dall’algoritmo solo nell’ultimo minuto di video, in quanto prima non può capitare l’evento “Fine nastro”.

Uno dei problemi sorti con questo approccio è l’eventuale presenza di polveri o impurità sul rullo pressore, se non pulito a dovere: a ogni rotazione queste vengono infatti rilevate come una diversità da notificare e il software salva quindi il frame. Poichè a noi interessa rilevare esclusivamente il movimento, si è notato che non è necessario selezionare il rullo in sè, ma basta selezionare l’area dove il rullo compie il movimento, come mostrato in figura 3.5. Dall’analisi di questo secondo rettangolo viene generato un file di testo contenente le informazioni relative all’evento “Fine nastro” (ovvero il nome del video e il timestamp) e il frame viene salvato in un’apposita cartella finenastro, in modo tale da essere già classificato.

Il problema, già presentato in sezione 2.2, della presenza di marche sul nastro comporta il salvataggio di ogni frame in cui tali stampe sono evidenti, poichè vengono rilevate come qualcosa da notificare (la soglia di pixel diversi tra due fotogrammi consecutivi viene infatti superata). Nel caso in cui le marche siano stampate di continuo su tutto il nastro (figura 3.6) l’algoritmo salva ogni frame che analizza.

Per questo motivo, si è introdotto un controllo ulteriore sui frame da salvare: in fase di configurazione (impostazione della soglia e selezione del video da analizzare) viene chiesto all’utente di indicare se sul nastro sono presenti marche in maniera continua; se presenti, viene attivato un secondo controllo sui frame già ritenuti interessanti, che consiste nel considerare la media del colore presente all’interno del rettangolo in analisi (media aritmetica del colore dei 3 canali RGB per ogni pixel della ROI). In questo modo, se il colore di due frame contigui è simile in media, significa che la differenza rilevata è una marca e l’immagine non viene salvata, altrimenti si tratta di una giunta (il cui colore è diverso da quello del nastro) e si procede regolarmente a salvare il fotogramma. Tale metodo è stato testato con colori che per l’occhio umano sono chiaramente diversi, ma che avrebbero potuto creare problemi all’algoritmo (e.g. giunta bianca su nastro giallo), portando a risultati decisamente migliori rispetto alla precedente versione (come mostrato in sezione 3.3). Inoltre, la prima marca individuata, ovvero la prima immagine che non supera il controllo, viene comunque salvata in un’apposita cartella marche.

L’attivazione di tale controllo si è rivelata utile anche nel caso di video con molte variazioni di luce, che portavano al salvataggio di numerosi frame con ombre. Tale metodo non può però essere utilizzato universalmente per tutti i nastri, in quanto andrebbero persi i frame contenenti scritte, segni o frammenti di nastro rovinato, la cui media di colore rimane stabile rispetto a quella dell’intero video.

Come spiegato in sezione 2.2, il software salva numerosi frame per una stessa discontinuità, poichè questa viene rilevata in posizioni diverse del nastro (in ingresso al frame, in posizione centrale e in uscita dal frame).
Tale problema è strettamente collegato alla velocità di riproduzione del nastro. Infatti, più lento è lo scorrimento, più frame della stessa giunta verranno catturati. La tabella 3.1 riporta un esempio del numero di frame salvati per una stessa giunta nello stesso nastro, riprodotto dapprima a una velocità di 7.5 ips e poi di 15 ips: dal primo video l’algoritmo estrae 6 frame, mentre dal secondo 3.

Tabella 3.1: Numero di frame salvati per una stessa giunta in due video riprodotti a velocità diverse.

Video | Velocità | Timestamp (ms) | HH:mm:ss
-----------------|----------|----------------|----------
Exp6 | 7.5 ips | 21360 | 00:00:21
Exp6 | 7.5 ips | 21400 | 00:00:21
Exp6 | 7.5 ips | 21440 | 00:00:21
Exp6 | 7.5 ips | 21480 | 00:00:21
Exp6 | 7.5 ips | 21520 | 00:00:21
Exp6 | 7.5 ips | 21560 | 00:00:21
Exp5 | 15 ips | 12680 | 00:00:12
Exp5 | 15 ips | 12720 | 00:00:12
Exp5 | 15 ips | 12760 | 00:00:12

L’analisi del video avviene a ogni frame e, poichè il video ha un frame rate di 25 frame al secondo, vengono estratte immagini anche ogni 40 millisecondi. Questo conduce a un dataset molto rumoroso, con moltissimi frame di scarso interesse, poichè molti si riferiscono alla stessa discontinuità. Per ridurre il numero di frame estratti, e quindi ridurre il rumore del dataset, si è deciso di lavorare sulla frequenza dei frame analizzati dall’algoritmo.

In un primo momento si è pensato di compiere l’analisi ogni due o più frame, confrontando quindi frame più distanti tra loro, non contigui, ma questo non ha condotto a buoni risultati: i frame salvati erano effettivamente meno, ma qualche giunta non veniva rilevata. Questo perchè se due frame distanti anche 80 (o più) millisecondi presentano entrambi una giunta dello stesso colore il software non si accorge che si tratta di due giunte diverse, il numero di pixel diversi non supera la soglia e il frame non viene salvato. Si è pertanto passati a un secondo approccio, che si è rivelato più vincente: il calcolo del numero di pixel differenti viene sempre effettuato su frame contigui, ma una volta decretata la presenza di una discontinuità all’interno del frame, quello successivo non viene salvato. Questo ha ridotto parecchio il numero di frame “rumorosi”. Si è poi pensato di correlare il numero di frame da non salvare alla velocità del nastro in questione. Pertanto, una volta individuato un frame interessante in un nastro a 7.5 ips verranno saltati i successivi due frame, andando a salvare eventualmente il frame presente 120 ms dopo. Per un nastro a 15 ips, invece, verrà saltato solo il frame successivo, andando a salvare, se necessario, quello presente 80 millisecondi dopo. Per tale motivo, in fase di configurazione viene chiesto all’utente di indicare la velocità di riproduzione del nastro.

## Test

Una volta apportate le modifiche al codice, si è testato il nuovo algoritmo sui video Esperimento5.mov (15 ips) ed Esperimento6.mov (7.5 ips), che erano stati creati appositamente per giudicare i risultati ottenuti nel lavoro precedente (come già spiegato in sezione 2.2.1) e che contengono un totale di 79 discontinuità.

In tabella 3.2 sono riassunti i risultati ottenuti dall’algoritmo originale e da quello con le modifiche presentate: si può vedere come gli obiettivi inizialmente prefissati siano stati raggiunti.

- Si è aumentata la precisione dell’algoritmo, vengono infatti trovate più discontinuità. In particolare, nel caso dei video in esame:
    - per il video a 7.5 ips il software trova tutte le discontinuità, selezionando due scritte su nastro e l’istante di fine nastro, che l’algoritmo originale non rilevava.
    - per il video a 15 ips vengono rilevate una scritta su nastro in più e la fine del nastro, ma ancora non viene trovata una scritta su nastro.
- È stato ridotto il rumore del dataset: per il video Esperimento5 vengono salvati quasi la metà dei frame rispetto all’algoritmo originale.
- Sono stati ridotti i tempi di analisi, grazie al fatto che vengono confrontati, e di conseguenza salvati, molti meno frame. Indicativamente, per un video della durata di circa un’ora l’algoritmo conclude l’analisi e l’estrazione dei frame in circa 16 minuti su un PC Alienware con CPU 4,00 GHz x8 (Intel Core i7).
- Si è trovata una soluzione efficiente per il problema delle marche, passando, per un video relativo a un nastro con marche, da un totale di 1368 frame salvati (numero decisamente troppo elevato per lo scopo del progetto) a 4 frame salvati (ovvero le 3 discontinuità presenti più il primo frame relativo alle marche).

Tabella 3.2: Risultati ottenuti dall’algoritmo originale e da quello con le modifiche presentate.

Video | Frame salvati dal vecchio algoritmo | Frame salvati dal nuovo algoritmo | Discontinuità individuate dal vecchio algoritmo | Discontinuità individuate dal nuovo algoritmo
-----------------|----------|----------------|----------|----------------
Exp5 (15 ips) | 205 | 109 | 76 | 78
Exp6 (7.5 ips) | 283 | 157 | 76 | 79
Nastro con marche | 1368 | 4 | 3 | 3
