#include "../src/lib/files.hpp"
#include <gtest/gtest.h>

using namespace files;

TEST(Files, SaveFile) {
    std::string content = "test";
    std::filesystem::path fileName = "tests/test.txt";
    save_file(fileName, content);
    std::ifstream file(fileName);
    std::string line;
    std::getline(file, line);
    EXPECT_EQ(line, content);
    file.close();
    std::filesystem::remove(fileName);
}

TEST(Files, GetFilenameAndExtension) {
    std::string videoPath = "tests/images/test_scene_01.jpg";
    std::pair<std::string, std::string> result = get_filename_and_extension(videoPath);
    EXPECT_EQ(result.first, "test_scene_01");
    EXPECT_EQ(result.second, "jpg");
}