#include "files.h"

#include <iostream>

using std::cout, std::endl, std::cerr, std::ofstream, std::ios;

void files::save_file(std::filesystem::path fileName, std::string content) {
    ofstream outputFile;
    outputFile.open(fileName);
    outputFile << content << endl;
    outputFile.close();
}

void files::findFileNameFromPath(std::string* path, std::string* fileName, std::string* extension) {
    *path = path->substr(path->find_last_of("'") + 1, path->size());
    std::string path_without_extension = path->substr(0, path->find_last_of("."));
    *fileName =
        path_without_extension.substr(path_without_extension.find_last_of("/") + 1, path_without_extension.size());
    *extension = path->substr(path->find_last_of(".") + 1, path->size());
}

std::pair<std::string, std::string> files::get_filename_and_extension(std::string videoPath) {
    std::string fileName, extension;
    files::findFileNameFromPath(&videoPath, &fileName, &extension);

    return std::pair<std::string, std::string>(fileName, extension);
}
