from fastapi import FastAPI, Response, status

import server.functions as functions

info = functions.get_file_content('server/documentation.yaml', 'yaml')
app = FastAPI(**info)


@app.get("/")
def index():
    return {"endpoints": ["irregularityFile1", "irregularityFile2", "description", "docs"]}


@app.get("/description")
async def get_description():
    return info


@app.get("/irregularityFile/{id}", status_code=200)
def get_irregularity_file(files_name: str, id: int, response: Response, working_path: str | None = None):

    required_file = f'VideoAnalyser_IrregularityFileOutput{id}.json'
    
    try:
        return functions.get_file_content(required_file, 'json')

    except:
        process = functions.analyze(files_name, working_path)

        if process.returncode == 0:
            return functions.get_file_content(required_file, 'json')

        else:
            response.status_code = status.HTTP_412_PRECONDITION_FAILED
            return {"error": {
                "returncode": process.returncode,
                "stdout": process.stdout.decode("utf-8"),
                "stderr": process.stderr.decode("utf-8"),
            }}
