#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Video Analyser AIM

This AIM analyses a Preservation Audio-Visual File to extract Irregularity Images of relevant interest.
"""

## import statements (built-in modules first, followed by third-party modules, followed by any changes to the path and your own modules)

import os
import subprocess
import sys

## input arguments

try:
    preservation_audio_visual_file = sys.argv[1]
    irregularity_file_input = sys.argv[2]
except IndexError:
    raise SystemExit(f"VideoAnalyser usage: {sys.argv[0]} <preservation_audio_visual_file> <irregularity_file_input>")

## code functions

def frame_extraction():
    # Declare frame_extraction Unix executable
    process = subprocess.run(["frame_extraction/bin/frame_extraction", sys.argv[1]], stdout=subprocess.PIPE)
    # Read the subprocess standard output and print it
    output = process.stdout.decode("utf-8")
    print(output)

# produce output jsons and irregularity images

frame_extraction()