#include "enums.h"

#include <stdexcept>

std::string sourceToString(Source source) {
    switch (source) {
        case Audio:
            return "a";
        case Video:
            return "v";
        case Both:
            return "b";
        default:
            throw std::invalid_argument("Invalid Source");
    }
}

Source sourceFromString(std::string source) {
    if (source == "a")
        return Audio;
    else if (source == "v")
        return Video;
    else if (source == "b")
        return Both;
    else
        throw std::invalid_argument("Invalid Source");
}

std::string irregularityTypeToString(IrregularityType type) {
    switch (type) {
        case BRANDS_ON_TAPE:
            return "b";
        case SPLICE:
            return "sp";
        case START_OF_TAPE:
            return "sot";
        case ENDS_OF_TAPE:
            return "eot";
        case DAMAGED_TAPE:
            return "da";
        case DIRT:
            return "di";
        case MARKS:
            return "m";
        case SHADOWS:
            return "s";
        case WOW_AND_FLUTTER:
            return "wf";
        case PLAY_PAUSE_STOP:
            return "pps";
        case SPEED:
            return "ssv";
        case EQUALIZATION:
            return "esv";
        case SPEED_AND_EQUALIZATION:
            return "ssv";
        case BACKWARD:
            return "sb";
        default:
            throw std::invalid_argument("Invalid IrregularityType");
    }
}

IrregularityType irregularityTypeFromString(std::string type) {
    if (type == "b")
        return BRANDS_ON_TAPE;
    else if (type == "sp")
        return SPLICE;
    else if (type == "sot")
        return START_OF_TAPE;
    else if (type == "eot")
        return ENDS_OF_TAPE;
    else if (type == "da")
        return DAMAGED_TAPE;
    else if (type == "di")
        return DIRT;
    else if (type == "m")
        return MARKS;
    else if (type == "s")
        return SHADOWS;
    else if (type == "wf")
        return WOW_AND_FLUTTER;
    else if (type == "pps")
        return PLAY_PAUSE_STOP;
    else if (type == "ssv")
        return SPEED;
    else if (type == "esv")
        return EQUALIZATION;
    else if (type == "ssv")
        return SPEED_AND_EQUALIZATION;
    else if (type == "sb")
        return BACKWARD;
    else
        throw std::invalid_argument("Invalid IrregularityType");
}