/**
 * @file colors.h
 * @author Matteo Spanio (dev2@audioinnova.com)
 * @brief Header file containing a set of ANSI escape codes to print colored
 * text in the terminal.
 *
 * When printing text in the terminal, it is possible to use ANSI escape codes
 * to change the color of the text. This header file contains a set of
 * pre-defined ANSI escape codes to print colored text in the terminal.
 *
 * @see https://en.wikipedia.org/wiki/ANSI_escape_code
 * @version 1.0
 * @date 2023-05-13
 * @copyright Copyright (c) 2023
 *
 */

#ifndef COLORS_H
#define COLORS_H
#include <stdlib.h>

#include <string>

using std::string;

string PURPLE = "\033[95m";
string CYAN = "\033[96m";
string DARK_CYAN = "\033[36m";
string BLUE = "\033[94m";
string GREEN = "\033[92m";
string YELLOW = "\033[93m";
string RED = "\033[91m";
string BOLD = "\033[1m";
string UNDERLINE = "\033[4m";
string END = "\033[0m";
#endif  // COLORS_H