# Software Requirements

The software should be able to, given as input the video of an open reel tape, produce as output two irregularity files where are listed the irregularities found in the video and the irregularities found in the audio.

Irregularity files are JSON files that contain a list of irregularities. Each irregularity is a JSON object that contains structured as follow:
```json
{
    "type": "object",
    "properties": {
        "IrregularityID": {
            "type": "string",
            "format": "uuid"
        },
        "Source": {
            "enum": ["a", "v", "b"]
        },
        "TimeLabel": {
            "type": "string",
            "pattern": "[0-9]{2}:[0-5][0-9]:[0-5][0-9]\\.[0-9]{3}"
        },
        "IrregularityType": {
            "enum": ["sp", "b", "sot", "eot", "da", "di", "m", "s", "wf", "pps", "ssv", "esv", "sb"]
        },
        "IrregularityProperties": {
            "type": "object",
            "properties": {
                "ReadingSpeedStandard": {
                    "enum": [0.9375, 1.875, 3.75, 7.5, 15, 30]
                },
                "ReadingEqualisationStandard": {
                    "enum": ["IEC", "IEC1", "IEC2"]
                },
                "WritingSpeedStandard": {
                    "enum": [0.9375, 1.875, 3.75, 7.5, 15, 30]
                },
                "WritingEqualisationStandard": {
                    "enum": ["IEC", "IEC1", "IEC2"]
                },
            }
        },
        "ImageURI": {
            "type": "string","format": "uri"
        },
        "AudioFileURI": {
            "type": "string",
            "format": "uri"
        }
    }
}
```