# Software Requirements

The software should be able to, given as input the video of an open reel tape, produce as output two irregularity files where are listed the irregularities found in the video and the irregularities found in the audio.

Irregularity files are JSON files that contain a list of irregularities. Each irregularity is a JSON object that contains structured as follow:
```js
{
    "type": "object",
    "properties": {
        "IrregularityID": {
            "type": "string",
            "format": "uuid"
        },
        "Source": {
            "enum": ["a", "v", "b"]
        },
        "TimeLabel": {
            "type": "string",
            "pattern": "[0-9]{2}:[0-5][0-9]:[0-5][0-9]\\.[0-9]{3}"
        },
        "IrregularityType": {
            "enum": ["sp", "b", "sot", "eot", "da", "di", "m", "s", "wf", "pps", "ssv", "esv", "sb"]
        },
        "IrregularityProperties": {
            "type": "object",
            "properties": {
                "ReadingSpeedStandard": {
                    "enum": [0.9375, 1.875, 3.75, 7.5, 15, 30]
                },
                "ReadingEqualisationStandard": {
                    "enum": ["IEC", "IEC1", "IEC2"]
                },
                "WritingSpeedStandard": {
                    "enum": [0.9375, 1.875, 3.75, 7.5, 15, 30]
                },
                "WritingEqualisationStandard": {
                    "enum": ["IEC", "IEC1", "IEC2"]
                },
            }
        },
        "ImageURI": {
            "type": "string","format": "uri"
        },
        "AudioFileURI": {
            "type": "string",
            "format": "uri"
        }
    }
}
```

Here follows a partial list of requirements and their implementation status:

| N° | Done | Name | Priority | Description |
|:-:|:-:|---|:--:|--|
| 1 | ✔️ | Analyze single preservation file | high | The app should take in input a signle PreservationVisualFile an analyze it |
| 2 | ❌️ | Analyze a list of files | medium | The app should take in input a list of files and analyze them in batch. |
| 3 | ✔ | Output the analysis results | high | The app should create as output 2 irregularity files, one containing only irregularities from video and the other containing also audio irregularities from audio analyser |
| 4 | ❌ | Irregularity file on demand | high | The app should accept as input a number that specifies the irregularity file required: if 1 returns only the irregularities from video in the irregularity file, if 2 return an iregularity file with irregularities from both video and audio analyser |


✔️ = done | 🚧 = in progress | ❌ = todo


