#include <iostream>
#include <fstream>
#include "validation.h"
#include "colors.h"

using namespace std;
namespace fs = std::filesystem;

int checkJSON(fs::path irregularityFileInputPath, float speed, int tapeThresholdPercentual, int capstanThresholdPercentual) {
	// Input JSON check
	ifstream iJSON(irregularityFileInputPath);
	if (iJSON.fail()) {
		cerr << RED << BOLD << "config.json error!" << END << endl << RED << irregularityFileInputPath.string() << " cannot be found or opened." << END << endl;
		return -1;
	}
	if (speed != 7.5 && speed != 15) {
		cerr << RED << BOLD << "config.json error!" << END << endl << RED << "Speed parameter must be 7.5 or 15 ips." << END << endl;
		return -1;
	}
	if (tapeThresholdPercentual < 0 || tapeThresholdPercentual > 100) {
		cerr << RED << BOLD << "config.json error!" << END << endl << RED << "TapeThresholdPercentual parameter must be a percentage value." << END << endl;
		return -1;
	}
	if (capstanThresholdPercentual < 0 || capstanThresholdPercentual > 100) {
		cerr << RED << BOLD << "config.json error!" << END << endl << RED << "CapstanThresholdPercentual parameter must be a percentage value." << END << endl;
		return -1;
	}
	return 0;
}