#include <iostream>
#include "parser.h"

using std::string, std::cout, std::endl, std::cerr;

/**
 * @brief Separates video file name from its extension.
 *
 * @param[in] path Full video path;
 * @param[out] fileName Video file name;
 * @param[out] extension Video extension.
 */
void findFileNameFromPath(string* path, string* fileName, string* extension) {
	*path = path->substr(path->find_last_of("'") + 1, path->size());
	string path_without_extension = path->substr(0, path->find_last_of("."));
	*fileName = path_without_extension.substr(path_without_extension.find_last_of("/") + 1, path_without_extension.size());
	*extension = path->substr(path->find_last_of(".") + 1, path->size());
}


/**
 * @brief Check if the specified input video file exists and is supported.
 *
 * @param[in] videoPath Full video path;
 * @param[out] fileName Video file name;
 * @param[out] extension Video extension.
 * @return int -1 if the format is not supported, 0 otherwise.
 */
int findFileName(string videoPath, string &fileName, string &extension) {

    findFileNameFromPath(&videoPath, &fileName, &extension);

    if (extension.compare("avi") != 0 && extension.compare("mp4") != 0 && extension.compare("mov") != 0) {
        cerr << "Input file extension must be \"avi\", \"mp4\" or \"mov\"." << endl;
        return -1;
    } else {
        cout << "Video to be analysed: " << endl;
        cout << "    File name:  " << fileName << endl;
        cout << "    Extension:  " << extension << endl;
    }
    return 0;
}