/**
 * @file files.h
 * @author Matteo Spanio (dev2@audioinnova.com)
 * @brief A collection of functions to handle files.
 * @version 1.0
 * @date 2023-05-13
 * 
 * @copyright Copyright (c) 2023
 * 
 */

#ifndef FILES_H
#define FILES_H
#include <filesystem>
#include <fstream>
#include <string>
#include <iostream>
#include <stdlib.h>

/**
 * @namespace files
 * @brief A collection of functions to handle files.
 * 
 */
namespace files {
    /**
     * @fn void saveFile(std::filesystem::path fileName, std::string content, bool append)
     * @brief Save content to a file
     * 
     * @param fileName the name of the file
     * @param content the content to be saved
     * @param append if true, the content will be appended to the file, otherwise the file will be overwritten
     */
    void saveFile(std::filesystem::path fileName, std::string content, bool append);

    /**
     * @fn void findFileNameFromPath(std::string* path, std::string* fileName, std::string* extension)
     * @brief Separates video file name from its extension.
     *
     * @param[in] path Full video path;
     * @param[out] fileName Video file name;
     * @param[out] extension Video extension.
     */
    void findFileNameFromPath(std::string* path, std::string* fileName, std::string* extension);

    /**
     * @fn int findFileName(std::string videoPath, std::string &fileName, std::string &extension)
     * @brief Check if the specified input video file exists and is supported.
     *
     * @param[in] videoPath Full video path;
     * @param[out] fileName Video file name;
     * @param[out] extension Video extension.
     * @return int -1 if the format is not supported, 0 otherwise.
     */
    int findFileName(std::string videoPath, std::string &fileName, std::string &extension);
}
#endif // FILES_H