#include <iostream>
#include "files.h"

using std::cout, std::endl, std::cerr, std::ofstream, std::ios;

void files::saveFile(std::filesystem::path fileName, std::string content, bool append) {
	ofstream outputFile;
	if (append) {
		outputFile.open(fileName, ios::app);
	} else {
		outputFile.open(fileName);
	}
	outputFile << content << endl;
	outputFile.close();
}

void files::findFileNameFromPath(std::string* path, std::string* fileName, std::string* extension) {
	*path = path->substr(path->find_last_of("'") + 1, path->size());
	std::string path_without_extension = path->substr(0, path->find_last_of("."));
	*fileName = path_without_extension.substr(path_without_extension.find_last_of("/") + 1, path_without_extension.size());
	*extension = path->substr(path->find_last_of(".") + 1, path->size());
}

int files::findFileName(std::string videoPath, std::string &fileName, std::string &extension) {

    files::findFileNameFromPath(&videoPath, &fileName, &extension);

    if (extension.compare("avi") != 0 && extension.compare("mp4") != 0 && extension.compare("mov") != 0) {
        cerr << "Input file extension must be \"avi\", \"mp4\" or \"mov\"." << endl;
        return -1;
    } else {
        cout << "Video to be analysed: " << endl;
        cout << "    File name:  " << fileName << endl;
        cout << "    Extension:  " << extension << endl;
    }
    return 0;
}

