#include <boost/lexical_cast.hpp>
#include <boost/uuid/uuid_io.hpp>
#include <boost/uuid/uuid.hpp>
#include <boost/uuid/uuid_generators.hpp>
#include "Irregularity.h"


Irregularity::Irregularity(Source source, string time_label, IrregularityType type, string image_URI)
{
    this->id = boost::uuids::random_generator()();
    this->source = source;
    this->time_label = time_label;
    this->type = type;
    this->image_URI = image_URI;
}

Irregularity::~Irregularity() {}

json Irregularity::toJSON() {
    json j;

    j["IrregularityID"] = boost::lexical_cast<string>(this->id);
    j["Source"] = sourceToString(this->source);
    j["TimeLabel"] = this->time_label;
    j["IrregularityType"] = irregularityTypeToString(this->type);
    if (!this->image_URI.empty())
        j["ImageURI"] = this->image_URI;

    return j;
}

Irregularity Irregularity::fromJSON(json j) {

    return Irregularity(
        sourceFromString(j["Source"]),
        j["TimeLabel"],
        irregularityTypeFromString(j["IrregularityType"]),
        j["ImageURI"]
    );
}
