/**
 * @file io.hpp
 * @author Matteo Spanio (dev2@audioinnova.com)
 * @brief Header file containing a set of functions related to the input/output
 * @version 1.2
 * @date 2023-06-03
 *
 * @copyright Copyright (c) 2023
 *
 */
#ifndef PRETTYIO_H
#define PRETTYIO_H
#include <iostream>
#include <string>

#include "colors.hpp"

using namespace colors;

namespace videoanalyser {
/**
 * @namespace io
 * @brief Namespace containing all the functions related to the input/output
 * operations.
 */
namespace io {
/**
 * @fn void pprint(std::string msg, Color color = WHITE)
 * @brief Print a colored message in the terminal.
 *
 * @param msg The message to print.
 * @param color The color of the message. Default is WHITE.
 */
void pprint(std::string msg, Color color = WHITE);
/**
 * @fn void print_error_and_exit(std::string msg)
 * @brief Print a colored message in the terminal and exit the program.
 *
 * @param msg The message to print.
 */
void print_error_and_exit(std::string msg);
}  // namespace io
}  // namespace videoanalyser

#endif  // PRETTYIO_H