# Documentation

[TOC]

> There is no worse software than undocumented software.

![Meme](../img/meme-documentation.jpg)

## Generate the documentation

Along with the source code, the documentation of the *Video Analyser* is provided in the `docs` folder. The documentation is generated with [Doxygen](https://www.doxygen.nl/index.html) and can be accessed by opening the `index.html` file in the `docs/html` folder with a browser.

To generate the documentation, run the following command from the root folder:
```
make docs
```

Note that Doxygen must be installed on your machine.

## Write the documentation

Doxygen is a tool for generating documentation from annotated C++ sources, as well as other popular programming languages like C, Objective-C, C#, PHP, Java, Python, IDL (Corba, Microsoft, and UNO/OpenOffice flavors), Fortran, VHDL, Tcl, and to some extent D.

To access Doxygen superpowers you need to add comments to your code. Doxygen supports two types of comments: single-line and multi-line comments. Single-line comments start with `///` or `//!` and multi-line comments start with `/**` and end with `*/`. The following example shows how to use both types of comments:

```
/// This is a single-line comment.

//! This is also a single-line comment.

/**
 * This is a multi-line comment.
 */
```

A sample of Doxygen commented class looks like this:

```
/**
 * @class SampleClass
 * @brief This is a sample class.
 *
 * This class is used to show how to comment a class with Doxygen.
 */
class SampleClass {
private:
    int field1; /**< This is a sample field. */
public:
    /**
     * @brief This is a sample constructor.
     *
     * This constructor is used to show how to comment a constructor with Doxygen.
     */
    SampleClass();

    /**
     * @brief This is a sample destructor.
     *
     * This destructor is used to show how to comment a destructor with Doxygen.
     */
    ~SampleClass();

    /**
     * @brief This is a sample method.
     *
     * This method is used to show how to comment a method with Doxygen.
     *
     * @param[in] param1 This is a sample parameter.
     * @param[in] param2 This is another sample parameter.
     * @return This is a sample return value.
     */
    int sampleMethod(int param1, int param2);
};
```

For more information about Doxygen, please refer to the [official documentation](https://www.doxygen.nl/manual/index.html).

# Style guide

The code is written following C++20 standard, to ensure the best readability and maintainability. The code is formatted using [clang-format](https://clang.llvm.org/docs/ClangFormat.html) with the [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html) as a reference.

To format the code, run the following command from the root folder:
```
make format
```

Note that clang-format must be installed on your machine.

In addition to the Google C++ Style Guide, the following rules are applied:

- when returning multiple values, use `std::tuple` or `std::pair`, instead of passing by reference;
- when dealing with nullable values, use `std::optional`;
- avoid to manipulate global variables, if you need to share data between different parts of the code, use dependency injection and pass the data as a parameter;

## Naming conventions

In C++, there are several naming conventions that are widely followed to improve code readability and maintainability. Although there is no strict standard enforced by the language, the following conventions are commonly used:

1. Variable Names:
   - Use descriptive and meaningful names that reflect the purpose of the variable.
   - Prefer lowercase letters for variable names.
   - Use underscores (_) to separate words in multi-word variable names.
   - Avoid using single uppercase letters as variable names, especially as standalone variables.

   Example: `int num_items;`

2. Function Names:
   - Use verbs or verb phrases to describe actions or operations performed by the function.
   - Prefer lowercase letters for function names.
   - Use underscores (_) to separate words in multi-word function names.
   - Use parentheses () for function parameters, even if they are empty.

   Example: `void calculate_average();`

3. Class/Struct Names:
   - Use noun phrases or nouns to describe the purpose or nature of the class/struct.
   - Use uppercase letters for each word (known as "PascalCase" or "camel case").
   - Avoid abbreviations unless they are widely recognized.

   Example: `class CustomerData;`

4. Constant Names:
   - Use uppercase letters for constants.
   - Use underscores (_) to separate words in multi-word constant names.
   - Prefer meaningful and self-explanatory names for constants.

   Example: `const int MAX_SIZE = 100;`

5. Global Variable Names:
   - Avoid using global variables whenever possible. However, if necessary, prefix them with `g_` or use a namespace to indicate their global nature.

   Example: `int g_global_variable;` or `namespace globals { int global_variable; }`
