#include <gtest/gtest.h>
#include <boost/uuid/uuid.hpp>
#include <boost/uuid/uuid_generators.hpp>
#include "../src/lib/Irregularity.h"

TEST(Irregularity, Init) {
    Irregularity irreg = Irregularity(
        Source::Video,
        "00:00:00.000",
        IrregularityType::WOW_AND_FLUTTER,
        "https://example.com/image.png"
    );

    Irregularity irreg2 = Irregularity(
        Source::Video,
        "00:00:00.000",
        IrregularityType::WOW_AND_FLUTTER,
        "https://example.com/image.png"
    );

    EXPECT_NE(irreg.id, irreg2.id);
    EXPECT_EQ(irreg.source, irreg2.source);
    EXPECT_EQ(irreg.time_label, irreg2.time_label);
    EXPECT_EQ(irreg.type, irreg2.type);
    EXPECT_EQ(irreg.image_URI, irreg2.image_URI);
}
