#include <exception>
#include "IrregularityFile.h"

IrregularityFile::IrregularityFile(uint16_t offset, std::list<Irregularity> irregularities)
    : offset(offset), irregularities(irregularities) {}

IrregularityFile::~IrregularityFile() {}

json IrregularityFile::toJSON() {

    json j;

    j["Offset"] = this->offset;

    return j;
}

IrregularityFile IrregularityFile::fromJSON(json j) {
    throw "Not implemented";
}

uint16_t IrregularityFile::getOffset() const {
    return this->offset;
}

std::list<Irregularity> IrregularityFile::getIrregularities() const {
    return this->irregularities;
}

IrregularityFile IrregularityFile::add(const Irregularity irregularity) {
    this->irregularities.push_back(irregularity);
    return *this;
}

IrregularityFile IrregularityFile::remove_by_id(const boost::uuids::uuid id) {
    for (auto it = this->irregularities.begin(); it != this->irregularities.end(); ++it) {
        if (it->id == id) {
            this->irregularities.erase(it);
            break;
        }
    }
    return *this;
}

IrregularityFile IrregularityFile::sort() {
    this->irregularities.sort([](const Irregularity& a, const Irregularity& b) {
        return a.time_label < b.time_label;
    });
    return *this;
}