import os
import subprocess
import json
from mpai_cae_arp.files import get_file_content


def analyze(files_name: str, working_path: str | None = None) -> subprocess.CompletedProcess:
    executable = os.path.abspath("frame_extraction/bin/frame_extraction")

    config = get_file_content("config/config.json", "json")

    # Update configuration file with query parameters
    config["FilesName"] = files_name
    if working_path is not None:
        config["WorkingPath"] = working_path
    with open("config/config.json", "w") as json_file:
        json.dump(config, json_file)

    process = subprocess.run([executable], capture_output=True)
    return process
