# Documentation

[TOC]

> There is no worse software than undocumented software.

![Meme](../img/meme-documentation.jpg)

## Generate the documentation

Along with the source code, the documentation of the *Video Analyser* is provided in the `docs` folder. The documentation is generated with [Doxygen](https://www.doxygen.nl/index.html) and can be accessed by opening the `index.html` file in the `docs/html` folder with a browser.

To generate the documentation, run the following command from the root folder:
```
make docs
```

Note that Doxygen must be installed on your machine.

## Write the documentation

Doxygen is a tool for generating documentation from annotated C++ sources, as well as other popular programming languages like C, Objective-C, C#, PHP, Java, Python, IDL (Corba, Microsoft, and UNO/OpenOffice flavors), Fortran, VHDL, Tcl, and to some extent D.

To access Doxygen superpowers you need to add comments to your code. Doxygen supports two types of comments: single-line and multi-line comments. Single-line comments start with `///` or `//!` and multi-line comments start with `/**` and end with `*/`. The following example shows how to use both types of comments:

```
/// This is a single-line comment.

//! This is also a single-line comment.

/**
 * This is a multi-line comment.
 */
```

A sample of Doxygen commented class looks like this:

```
/**
 * @class SampleClass
 * @brief This is a sample class.
 *
 * This class is used to show how to comment a class with Doxygen.
 */
class SampleClass {
private:
    int field1; /**< This is a sample field. */
public:
    /**
     * @brief This is a sample constructor.
     *
     * This constructor is used to show how to comment a constructor with Doxygen.
     */
    SampleClass();

    /**
     * @brief This is a sample destructor.
     *
     * This destructor is used to show how to comment a destructor with Doxygen.
     */
    ~SampleClass();

    /**
     * @brief This is a sample method.
     *
     * This method is used to show how to comment a method with Doxygen.
     *
     * @param[in] param1 This is a sample parameter.
     * @param[in] param2 This is another sample parameter.
     * @return This is a sample return value.
     */
    int sampleMethod(int param1, int param2);
};
```

For more information about Doxygen, please refer to the [official documentation](https://www.doxygen.nl/manual/index.html).

# Style guide

The code is written following C++20 standard, to ensure the best readability and maintainability. The code is formatted using [clang-format](https://clang.llvm.org/docs/ClangFormat.html) with the [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html) as a reference.

To format the code, run the following command from the root folder:
```
make format
```

Note that clang-format must be installed on your machine.

In addition to the Google C++ Style Guide, the following rules are applied:

- when returning multiple values, use `std::tuple` or `std::pair`, instead of passing by reference;
- when dealing with nullable values, use `std::optional`;
- avoid to manipulate global variables, if you need to share data between different parts of the code, use dependency injection and pass the data as a parameter;