#ifndef IRREGULARITY_H
#define IRREGULARITY_H
#include <boost/uuid/uuid.hpp>
#include <nlohmann/json.hpp>
#include "enums.h"

using std::string;
using json = nlohmann::json;

/**
 * @brief an irregularity of the tape detected by the system
 * 
 */
struct Irregularity
{
    boost::uuids::uuid id;
    Source source;
    string time_label;
    IrregularityType type;
    string image_URI;

    Irregularity(Source source, string time_label, IrregularityType type, string image_URI);
    ~Irregularity();
    json toJSON();
    static Irregularity fromJSON(json j);
};

#endif // IRREGULARITY_H