#ifndef IRREGULARITY_FILE_H
#define IRREGULARITY_FILE_H
#include <list>
#include <nlohmann/json.hpp>
#include "Irregularity.h"

using json = nlohmann::json;

/**
 * @class IrregularityFile
 * @brief An IrregularityFile is a collection of Irregularities detected on a tape.
 * 
 */
class IrregularityFile
{
private:
    /* data */
    uint16_t offset;
    std::list<Irregularity> irregularities;

public:
    IrregularityFile(uint16_t offset, std::list<Irregularity> irregularities);
    ~IrregularityFile();

    static IrregularityFile fromJSON(const json j);
    json toJSON();

    uint16_t getOffset() const;
    std::list<Irregularity> getIrregularities() const;
    IrregularityFile& add(const Irregularity irregularity);
    IrregularityFile& remove_by_id(const boost::uuids::uuid id);
    IrregularityFile& sort();
};

#endif // IRREGULARITY_FILE_H