#include "time.h"

using namespace std;

/**
 * @brief Convert an int representing milliseconds to the corresponding Time Label string.
 *
 * @param ms the number of milliseconds.
 * @param delim the time separator
 * @return string the corresponding Time Label string.
 */
string getTimeLabel(int ms, string delim) {

	int mil = ms % 1000;
	int sec = ms / 1000;
	int min = (sec / 60) % 60;
	int hours = sec / 3600;
	sec = sec % 60;

	string hoursStr = to_string(hours), minStr = to_string(min), secStr = to_string(sec), milStr = to_string(mil);
	if (hours < 10)
		hoursStr = "0" + hoursStr;
	if (min < 10)
		minStr = "0" + minStr;
	if (sec < 10)
		secStr = "0" + secStr;
	if (mil < 100) {
		if (mil < 10) {
			milStr = "00" + milStr;
		} else {
			milStr = "0" + milStr;
		}
	}

    string timeLabel = hoursStr + delim + minStr + delim + secStr + delim + milStr;

	return timeLabel;
}
