import os
import subprocess
from mpai_cae_arp.files import File, FileType


def analyze(files_name: str, working_path: str | None = None) -> subprocess.CompletedProcess:
    executable = os.path.abspath("bin/video_analyser")

    config_file = File("config/config.json", FileType.JSON)
    config = config_file.get_content()

    # Update configuration file with query parameters
    config["FilesName"] = files_name
    if working_path is not None:
        config["WorkingPath"] = working_path
    config_file.write_content(config)

    process = subprocess.run([executable], capture_output=True)
    return process
