#include <gtest/gtest.h>
#include <boost/uuid/uuid.hpp>
#include <boost/uuid/uuid_generators.hpp>
#include "../src/lib/enums.h"

TEST(IrregularityType, toString) {
    EXPECT_EQ(irregularityTypeToString(IrregularityType::WOW_AND_FLUTTER), "wf");
}

TEST(IrregularityType, fromString) {
    EXPECT_EQ(irregularityTypeFromString("wf"), IrregularityType::WOW_AND_FLUTTER);
    EXPECT_THROW(irregularityTypeFromString("not_exists"), std::invalid_argument);
}
