# Video Analyser

[![MPAI CAE-ARP](https://img.shields.io/badge/MPAI%20CAE--ARP-gray?style=for-the-badge&logo=AppleMusic&logoColor=cyan&link=https://mpai.community/standards/mpai-cae/about-mpai-cae/)](https://mpai.community/standards/mpai-cae/about-mpai-cae/)

[TOC]

## Description
Implements the Technical Specification of [MPAI CAE-ARP](https://mpai.community/standards/mpai-cae/about-mpai-cae/#Figure2) *Video Analyser* AIM, providing:
* 2 Irregularity Files;
* Irregularity Images.

## Quick start

Clone the repository:
```
git clone https://gitlab.dei.unipd.it/mpai/video-analyzer.git
```

Install the dependencies:
- [Boost C++ Libraries](https://www.boost.org);
- [OpenCV](https://docs.opencv.org/4.x/index.html);
- [nlohmann/json](https://github.com/nlohmann/json).

Build the project from the root directory:
```
make build
```

Add the Preservation Files to the `data` directory following this structure:
```
data
├── PreservationAudioFile
│   ├── File1.wav
│   ├── File2.wav
│   └── ...
└── PreservationAudioVisualFile
    ├── File1.mp4
    ├── File2.mp4
    └── ...
```

Run the project from the root directory:
```
make run
```

## Documentation
Along with the source code, the documentation of the *Video Analyser* is provided in the `docs` folder. The documentation is generated with [Doxygen](https://www.doxygen.nl/index.html) and can be accessed by opening the `index.html` file in the `docs/html` folder with a browser.

To generate the documentation, run the following command from the root folder:
```
make docs
```

Note that Doxygen must be installed on your machine.

## Support
If you require additional information or have any problem, you can contact us at:
* Nadir Dalla Pozza (nadir.dallapozza@unipd.it);
* Niccolò Pretto (niccolo.pretto@unipd.it).

## Authors and acknowledgment
This project was developed by:
* Nadir Dalla Pozza (University of Padova);
* Niccolò Pretto (University of Padova);
* Sergio Canazza (University of Padova).

This project takes advantage of the following libraries:
* [Boost C++ Libraries](https://www.boost.org);
* [OpenCV](https://docs.opencv.org/4.x/index.html);
* [nlohmann/json](https://github.com/nlohmann/json).

Developed with IDE [Visual Studio Code](https://code.visualstudio.com).

## License
This project is licensed with [GNU GPL v3.0](https://www.gnu.org/licenses/gpl-3.0.html).