#include "time.hpp"

std::string getTimeLabel(int ms, std::string delim) {
    int mil = ms % 1000;
    int sec = ms / 1000;
    int min = (sec / 60) % 60;
    int hours = sec / 3600;
    sec = sec % 60;

    std::string hoursStr = std::to_string(hours), minStr = std::to_string(min), secStr = std::to_string(sec),
                milStr = std::to_string(mil);
    if (hours < 10) hoursStr = "0" + hoursStr;
    if (min < 10) minStr = "0" + minStr;
    if (sec < 10) secStr = "0" + secStr;
    if (mil < 100) {
        if (mil < 10) {
            milStr = "00" + milStr;
        } else {
            milStr = "0" + milStr;
        }
    }

    std::string timeLabel = hoursStr + delim + minStr + delim + secStr + delim + milStr;

    return timeLabel;
}

int time_label_to_ms(std::string time_label) {

    // Obtain time measures from JSON
    int h = stoi(time_label.substr(0, 2));
    int min = stoi(time_label.substr(3, 2));
    int sec = stoi(time_label.substr(6, 2));
    int ms = stoi(time_label.substr(9, 3));

    // Compute the Irregularity instant in milliseconds
    return ms + sec * 1000 + min * 60000 + h * 3600000;
}