#include "../src/lib/Irregularity.hpp"

#include <gtest/gtest.h>

#include <boost/uuid/uuid.hpp>
#include <boost/uuid/uuid_generators.hpp>

TEST(Irregularity, Init) {
    Irregularity irreg = Irregularity(Source::Video, "00:00:00.000", IrregularityType::WOW_AND_FLUTTER)
                             .set_image_URI("https://example.com/image.png");

    Irregularity irreg2 = Irregularity(Source::Video, "00:00:00.000", IrregularityType::WOW_AND_FLUTTER)
                              .set_image_URI("https://example.com/image.png");

    EXPECT_NE(irreg.get_id(), irreg2.get_id());
    EXPECT_EQ(irreg.get_source(), irreg2.get_source());
    EXPECT_EQ(irreg.get_time_label(), irreg2.get_time_label());
    EXPECT_EQ(irreg.get_type(), irreg2.get_type());
    EXPECT_EQ(irreg.get_image_URI(), irreg2.get_image_URI());
    EXPECT_EQ(irreg.get_audio_URI(), irreg2.get_audio_URI());
}
