#include "enums.hpp"

std::string sourceToString(Source source) {
    switch (source) {
        case Source::Audio:
            return "a";
        case Source::Video:
            return "v";
        case Source::Both:
            return "b";
        default:
            throw std::invalid_argument("Invalid Source");
    }
}

Source sourceFromString(std::string source) {
    if (source == "a")
        return Source::Audio;
    else if (source == "v")
        return Source::Video;
    else if (source == "b")
        return Source::Both;
    else
        throw std::invalid_argument("Invalid Source");
}

std::string irregularityTypeToString(IrregularityType type) {
    switch (type) {
        case IrregularityType::BRANDS_ON_TAPE:
            return "b";
        case IrregularityType::SPLICE:
            return "sp";
        case IrregularityType::START_OF_TAPE:
            return "sot";
        case IrregularityType::ENDS_OF_TAPE:
            return "eot";
        case IrregularityType::DAMAGED_TAPE:
            return "da";
        case IrregularityType::DIRT:
            return "di";
        case IrregularityType::MARKS:
            return "m";
        case IrregularityType::SHADOWS:
            return "s";
        case IrregularityType::WOW_AND_FLUTTER:
            return "wf";
        case IrregularityType::PLAY_PAUSE_STOP:
            return "pps";
        case IrregularityType::SPEED:
            return "ssv";
        case IrregularityType::EQUALIZATION:
            return "esv";
        case IrregularityType::SPEED_AND_EQUALIZATION:
            return "ssv";
        case IrregularityType::BACKWARD:
            return "sb";
        default:
            throw std::invalid_argument("Invalid IrregularityType");
    }
}

IrregularityType irregularityTypeFromString(std::string type) {
    if (type == "b")
        return IrregularityType::BRANDS_ON_TAPE;
    else if (type == "sp")
        return IrregularityType::SPLICE;
    else if (type == "sot")
        return IrregularityType::START_OF_TAPE;
    else if (type == "eot")
        return IrregularityType::ENDS_OF_TAPE;
    else if (type == "da")
        return IrregularityType::DAMAGED_TAPE;
    else if (type == "di")
        return IrregularityType::DIRT;
    else if (type == "m")
        return IrregularityType::MARKS;
    else if (type == "s")
        return IrregularityType::SHADOWS;
    else if (type == "wf")
        return IrregularityType::WOW_AND_FLUTTER;
    else if (type == "pps")
        return IrregularityType::PLAY_PAUSE_STOP;
    else if (type == "ssv")
        return IrregularityType::SPEED;
    else if (type == "esv")
        return IrregularityType::EQUALIZATION;
    else if (type == "ssv")
        return IrregularityType::SPEED_AND_EQUALIZATION;
    else if (type == "sb")
        return IrregularityType::BACKWARD;
    else
        throw std::invalid_argument("Invalid IrregularityType");
}