/**
 * @file colors.hpp
 * @author Matteo Spanio (dev2@audioinnova.com)
 * @brief Header file containing a set of ANSI escape codes to print colored
 * text in the terminal.
 *
 * When printing text in the terminal, it is possible to use ANSI escape codes
 * to change the color of the text. This header file contains a set of
 * pre-defined ANSI escape codes to print colored text in the terminal.
 *
 * @see https://en.wikipedia.org/wiki/ANSI_escape_code
 * @version 1.0
 * @date 2023-05-13
 * @copyright Copyright (c) 2023
 *
 */

#ifndef COLORS_H
#define COLORS_H

namespace colors {
using Color = const char*;
constexpr Color PURPLE = "\033[95m";
constexpr Color CYAN = "\033[96m";
constexpr Color DARK_CYAN = "\033[36m";
constexpr Color BLUE = "\033[94m";
constexpr Color GREEN = "\033[92m";
constexpr Color YELLOW = "\033[93m";
constexpr Color RED = "\033[91m";
constexpr Color WHITE = "\033[97m";
constexpr Color BOLD = "\033[1m";
constexpr Color UNDERLINE = "\033[4m";
constexpr Color END = "\033[0m";
}  // namespace colors

#endif  // COLORS_H