import os
import subprocess
import json
import yaml
from fastapi import FastAPI, Response, status

with open("VideoAnalyser.json") as json_file:
    info = json.load(json_file)

app = FastAPI(
    title="Video Analyser",
    description=info["Description"],
    version=info["Identifier"]["Specification"]["Version"],
    contact={
        "name": "Matteo Spanio",
        "email": "dev2@audioinnova.com",
    },
    license_info={
        "name": "GPL-3.0 License",
        "url": "http://www.gnu.org/licenses/gpl-3.0.html"
    }
)


@app.get("/")
def index():
    return {"endpoints": ["analyze", "docs"]}


@app.get("/description")
async def get_description():
    with open('server/documentation.yaml') as yaml_file:
        documentation = yaml.safe_load(yaml_file)
    return documentation


@app.get("/analyze", status_code=200)
async def analyze(files_name: str, response: Response, working_path: str | None = None ):

    executable = os.path.abspath("frame_extraction/bin/frame_extraction")

    # Read configuration file
    with open("config/config.json") as json_file:
        config = json.load(json_file)

    # Update configuration file with query parameters
    config["FilesName"] = files_name
    if working_path is not None:
        config["WorkingPath"] = working_path
    with open("config/config.json", "w") as json_file:
        json.dump(config, json_file)

    process = [
        executable,
        ]

    cprocess = subprocess.run(process, capture_output=True)

    if cprocess.returncode == 0:

        with open('AudioAnalyser_IrregularityFileOutput1.json') as json_file:
            editing_list = json.load(json_file)
        return editing_list

    else:
        response.status_code = status.HTTP_412_PRECONDITION_FAILED
        return {"error": {
            "returncode": cprocess.returncode,
            "stdout": cprocess.stdout.decode("utf-8"),
            "stderr": cprocess.stderr.decode("utf-8"),
        }}
